function [obj] = vb_f_stack_push(obj, data)
% push data into file stack
% [USAGE]
%    [obj] = vb_f_stack_push(<obj>, <data>);
% [IN]
%     obj : f_stack object.
%    data : push data into f_stack.
% [OUT]
%    obj : f_stack object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
if ~isinf(obj.stack_size) && (length(obj.queue) >= obj.stack_size)
    % delete top
    delete(obj.queue{1}); % file delete
    obj.queue(1) = [];
end

% push back
temp_file = [tempname, '.mat'];
vb_fsave(temp_file, 'data');
obj.queue{length(obj.queue)+1} = temp_file;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end

