function vb_f_stack_delete(obj)
% clean up temporary files
% [USAGE]
%    vb_f_stack_delete(obj);
% [IN]
%    obj : f_stack object
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end

%
% --- Main Procedure
%
for k=length(obj.queue):-1:1
    if ~isempty(obj.queue{k}) && exist(obj.queue{k}, 'file') == 2
        delete(obj.queue{k});
        obj.queue(k) = [];
    end
end

%
% --- After check
%
