function [] = set_gui_property(dialog)
% Dialog windowGUIproperty򹹿롣
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

this = get(dialog,'UserData');

% dialog title򹹿롣
if isempty(this.public.dialog_title)
  if this.public.save_mode
    dialog_title = 'select SAVE file';
  else
    dialog_title = 'select LOAD file';
  end
  set(this.private.gui_handles.dialog, 'Name', dialog_title);
else
  set(this.private.gui_handles.dialog, 'Name', this.public.dialog_title);
end

% histry directorycurrent directoryɲä롣
current = 0;
hist_num = length( this.public.hist_dir );
hist_dir = cell(1,hist_num+1);
for ii=1:hist_num
  hist_dir{ii+1} = this.public.hist_dir{ii};
  if strcmp( this.public.current_dir, deblank(this.public.hist_dir{ii}) )
    current = ii;
  end
end
if ~current
  current = 1;
  hist_dir{1} = this.public.current_dir;
  this.public.hist_dir = hist_dir;
end

% ǥ쥯ȥ򤹤pop-up menu˥ǥ쥯ȥ̾ꤹ롣
str = sprintf('|%s', this.public.hist_dir{:});	str(1) = [];
set(this.private.gui_handles.current_dir_popup,...
    'String', str, 'Value', current);

% Drive̾򤹤popup-menu򹹿롣
if length( this.private.drive_info )
  str = sprintf('|%s', this.private.drive_info(:).drive);
  str(1) = [];
  set(this.private.gui_handles.drive_text, 'Enable', 'on');
  set(this.private.gui_handles.drive_popup,...
      'Enable', 'on', 'String', str, 'Value', this.private.current_drive);
else	% WindowsĶʳǤ̵
  set(this.private.gui_handles.drive_text, 'Enable', 'off');
  set(this.private.gui_handles.drive_popup, 'Enable', 'off');
end


% ǥ쥯ȥΥǥ쥯ȥ̾(file_extensionγĥҤ)
% ե̾ΰ롣
current_extension = get(this.private.gui_handles.extension_popup, 'Value');
this.public.filter_str = get(this.private.gui_handles.filter_str_edit, 'String');
[files, dirs] = list_files(this.public.current_dir,...
    this.public.file_extensions{current_extension},...
    this.public.filter_str);


% ǥ쥯ȥ򹹿롣
if length(dirs)
  str = sprintf('|%s', dirs{:});	str(1) = [];
  active_dir = find( strcmp(dirs, '.') );
  if isempty( active_dir )
    str = sprintf('.|%s', str);
    active_dir = 1;
  end
  set(this.private.gui_handles.dir_listbox, 'String', str,...
      'Min',0, 'Max',1, 'Value',active_dir, 'Enable','on');
else
  set(this.private.gui_handles.dir_listbox, 'String', '',...
      'Min',0, 'Max', 0, 'Value',[], 'Enable', 'off');
end


% ե򹹿롣
current_file = [];
if length(files)
  str = sprintf('%s|', files{:});	str(length(str)) = '';
  for ii=1:length(this.private.current_file)
    tmp = find( strcmp(files, this.private.current_file{ii}) );
    if length(tmp)
      current_file = [current_file, tmp];
    end
  end

  set(this.private.gui_handles.fname_listbox, 'String', str,...
      'Min',0, 'Max', 2, 'Value', current_file, 'Enable', 'on');
else
  set(this.private.gui_handles.fname_listbox, 'String', '',...
      'Min',0, 'Max', 0, 'Value', current_file, 'Enable', 'off');
end


% ե̾ɽedit text򹹿롣
if isempty(this.private.current_file)
  filename = '';	% file̤
elseif length(this.private.current_file) == 1
  if this.public.save_mode	% SAVE⡼:file̾Τɽ롣
    filename = this.private.current_file{1};
  else	% LOAD⡼:full pathɽ롣
    filename =...
	fullfile( this.public.current_dir, this.private.current_file{1} );
  end
else	% ʣfile
  filename = '';
  for ii=1:length(this.private.current_file)
    filename = sprintf('%s ''%s''', filename, this.private.current_file{ii});
  end
end
set(this.private.gui_handles.sel_fname_edit, 'String', filename);
set_horizontal_alignment( this.private.gui_handles.sel_fname_edit );


% 'Done' push button򹹿롣
if isempty( this.private.current_file )
  set(this.private.gui_handles.done_push,...
      'FontWeight','normal', 'Enable','off');
else
  set(this.private.gui_handles.done_push,...
      'FontWeight','bold', 'Enable','on');
end

set(dialog, 'UserData', this);
% End of 'function [] = set_gui_property(dialog)'


function [files,dirs] = list_files(wdir, file_extension, filter_str)
% ꤷdirectory򸡺롣
% wdir : directory̾
% file_extension : եĥ
% filter_str : ʤʸ

if isempty(filter_str)
    filter_str = '*';
end
filter_str = strrep(filter_str, '.', '\.');
filter_str = strrep(filter_str, '*', '.*');
filter_str = ['^', filter_str, '.*'];

d = dir(wdir);
files = {};	files_num = 0;
dirs = {};	dirs_num = 0;
for ii=1:length(d)
  if d(ii).isdir	% directory̾ɲä롣
    dirs_num = dirs_num+1;
    dirs{dirs_num} = d(ii).name;
  else
    if strcmp(file_extension, '.*')
      append = 1;	% 磻ɥ(ե븡оݤȤ롣)
    else
      p = findstr(d(ii).name, file_extension);
      f = regexp(d(ii).name, filter_str);
      if ~isempty(f) & ...
         ~isempty(p) &...
	    p(length(p))==length(d(ii).name)-(length(file_extension)-1)
	append = 1;
      else
	append = 0;
      end
    end	% <-- End of 'if strcmp(file_extension, '.*') ... else ....'
    
    if append	% file̾ɲä롣
      files_num = files_num+1;
      files{files_num} = d(ii).name;
    end

  end	% <-- End of 'if d(ii).isdir ... else ...'
end	% <-- End of 'for ii=1:length(d)'
% End of 'function [files,dirs] = list_files(wdir, file_extension)'


function set_horizontal_alignment(handle)

if isunix
  p = get(handle, 'Position');
  ext = get(handle,'Extent');
  if p(3) < ext(3)	set(handle,'HorizontalAlignment','right');
  else			set(handle,'HorizontalAlignment','left');
  end
else
    set(handle,'HorizontalAlignment','left');
end
% End of 'function set_horizontal_alignment(handle)'
