function [gui_handles] = create_gui(this)
% dialog window롣
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

S = get(0,'ScreenSize');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Dialog window礭
Width = 380;
Height = 440;


BorderH = 10;
BorderV = 5;


% 'Current directory' static text label礭Ȱ
CurrentDirTextWidth = Width - 2*BorderH;
CurrentDirTextHeight = 20;
CurrentDirTextLeft = BorderH;
CurrentDirTextBottom = Height - CurrentDirTextHeight;

% current directory򤹤pop-up menu礭Ȱ
CurrentDirPopupWidth = Width - 2*BorderH;
CurrentDirPopupHeight = 20;
CurrentDirPopupLeft = BorderH;
CurrentDirPopupBottom = CurrentDirTextBottom - CurrentDirPopupHeight;


% 'Extension' static text label礭Ȱ
ExtensionTextWidth = 0.6*(CurrentDirPopupWidth/2);
ExtensionTextHeight = 20;
ExtensionTextLeft = BorderH;
ExtensionTextBottom = CurrentDirPopupBottom - (ExtensionTextHeight+BorderV);

% ĥҤ򤹤pop-up menu礭Ȱ
ExtensionPopupWidth = CurrentDirPopupWidth/2 - ExtensionTextWidth;
ExtensionPopupHeight = ExtensionTextHeight;
ExtensionPopupLeft = ExtensionTextLeft + ExtensionTextWidth;
ExtensionPopupBottom = ExtensionTextBottom;


% 'Drive' static text label礭Ȱ
DriveTextWidth = ExtensionTextWidth;
DriveTextHeight = ExtensionPopupHeight;
DriveTextLeft = ExtensionPopupLeft + ExtensionPopupWidth;
DriveTextBottom = ExtensionPopupBottom;

% Drive򤹤pop-up menu礭Ȱ
DrivePopupWidth = ExtensionPopupWidth;
DrivePopupHeight = DriveTextHeight;
DrivePopupLeft = DriveTextLeft + DriveTextWidth;
DrivePopupBottom = DriveTextBottom;


% panel礭Ȱ
PanelWidth = CurrentDirPopupWidth;
PanelHeighth = 320;
PanelLeft = BorderH;
PanelBottom = ExtensionTextBottom - (PanelHeighth+BorderV);


% MATLAB R14 SP2ʹߤʤpanelGUIpanelƤȤƺ롣
% panelƤȤƺcontrolɽ֤ϡpanelа֤ǻꤹ롣
% ޤpanel'visible''off'ˤȡGUIɽ롣
% MATLAB R14ΥСǤϡpanelݡȤƤʤ
% ޤMATLABR14 SP1Ǥpanelư԰ʤΤǡframecontrol
% dialogƤȤƺ롣
% ξ硢GUIŤʤ礦ΰϡ夫GUIͥ褷ɽ롣

% R14 SP1 = 7.0.1, SP2 = 7.0.4
[major, minor, rev] = vb_matlab_version;
version_value = 100*major + 10*minor + rev * 1;
if version_value < 704
  TmpLeft = PanelLeft;	TmpBottom = PanelBottom;
else
  TmpLeft = 0;	TmpBottom = 0;
end
    


% 'Directories' static text label礭Ȱ
DirTextWidth = PanelWidth*2/5 - BorderH;
DirTextHeight = 20;
DirTextLeft = TmpLeft + BorderH;
DirTextBottom = TmpBottom + PanelHeighth - (DirTextHeight+BorderV);

% ǥ쥯ȥɽlist box礭Ȱ
DirListWidth = DirTextWidth;
DirListHeight = 180;
DirListLeft = DirTextLeft;
DirListBottom = DirTextBottom - DirListHeight;


% 'Files' static text label礭Ȱ
FnameTextWidth = PanelWidth - DirTextWidth - 2*BorderH;
FnameTextHeight = DirTextHeight;
FnameTextLeft = DirTextLeft + DirTextWidth;
FnameTextBottom = DirTextBottom;

% ե̾ɽlist box礭Ȱ
FnameListWidth = FnameTextWidth;
FnameListHeight = DirListHeight;
FnameListLeft = FnameTextLeft;
FnameListBottom = DirListBottom;


% 'Filter' static text label
FilterFnameTextWidth = PanelWidth - 2*BorderH;
FilterFnameTextHeight= 20;
FilterFnameTextLeft  = TmpLeft + BorderH;
FilterFnameTextBottom= DirListBottom - (FilterFnameTextHeight+BorderV);

% 'Filter' edit text
FilterFnameEditWidth = FilterFnameTextWidth;
FilterFnameEditHeight= 22;
FilterFnameEditLeft  = FilterFnameTextLeft;
FilterFnameEditBottom= FilterFnameTextBottom - FilterFnameEditHeight;

% 'Select file' static text label礭Ȱ
SelFnameTextWidth = PanelWidth - 2*BorderH;
SelFnameTextHeight = 20;
SelFnameTextLeft = TmpLeft + BorderH;
SelFnameTextBottom = FilterFnameEditBottom - (SelFnameTextHeight+BorderV);

% ե̾ɽedit text礭Ȱ
SelFnameEditWidth = SelFnameTextWidth;
SelFnameEditHeight = 22;
SelFnameEditLeft = SelFnameTextLeft;
SelFnameEditBottom = SelFnameTextBottom - SelFnameEditHeight;


% 'Cancel' push button礭Ȱ
CancelWidth = CurrentDirPopupWidth/2;
CancelHeight = 35;
CancelLeft = BorderH;
CancelBottom = PanelBottom - (CancelHeight+BorderV);

% 'Done' push button礭Ȱ
DoneWidth = CancelWidth;
DoneHeight = CancelHeight;
DoneLeft = CancelLeft + CancelWidth;
DoneBottom = CancelBottom;


% GUIο롣
dialog_color   = this.public.dialog_color;	% dialogcolor
dialog_title   = this.public.dialog_title;	% dialogtitle
bgcol_panel = this.public.bgcol_panel;	% panelbackground color
fgcol_panel = this.public.fgcol_panel;	% panelforeground color
fgcol_text  = this.public.fgcol_text;	% static text labelforeground color
bgcol_popup = this.public.bgcol_popup;	% pop-up menubackground color
fgcol_popup = this.public.fgcol_popup;	% pop-up menuforeground color
bgcol_listbox = this.public.bgcol_listbox;	% list boxbackground color
fgcol_listbox = this.public.fgcol_listbox;	% list boxforeground color
bgcol_edit  = this.public.bgcol_edit;	% edit textbackground color
fgcol_edit  = this.public.fgcol_edit;	% edit textforeground color
bgcol_push  = this.public.bgcol_push;	% push buttonbackground color
fgcol_push  = this.public.fgcol_push;	% push buttonforeground color


% Save/Load fileDialog window롣
dialog_handle = figure('Name', dialog_title, 'Tag', 'SelFileWin',...
    'MenuBar', 'none',...
    'NumberTitle', 'off',...
    'Color', dialog_color,...
    'Resize', 'off',...
    'Visible', 'off',...
    'Units', 'Pixels',...
    'Position',...
    [S(3)/2-Width/2, S(4)/2-Height/2, Width, Height]);

% 'Current directory' static text label롣
uicontrol('Parent', dialog_handle, 'Style', 'text',...
    'String', 'current directory',...
    'BackgroundColor', dialog_color, 'ForegroundColor', fgcol_text,...
    'HorizontalAlignment', 'Left', 'FontSize', 12,...
    'Position',...
    [CurrentDirTextLeft, CurrentDirTextBottom,...
      CurrentDirTextWidth, CurrentDirTextHeight]);

% current directory򤹤pop-up menu롣
current_dir_popup_handle = uicontrol('Parent',dialog_handle,...
    'Style', 'popup', 'String', ' ', 'Value', 1,...
    'BackgroundColor', bgcol_popup, 'ForegroundColor', fgcol_popup,...
    'HorizontalAlignment', 'Left', 'FontSize', 12,...
    'CallBack', {@current_dir_popup, dialog_handle},...
    'Position',...
    [CurrentDirPopupLeft, CurrentDirPopupBottom,...
      CurrentDirPopupWidth, CurrentDirPopupHeight]);


% 'Extension' static text label롣
uicontrol('Parent', dialog_handle, 'Style', 'text',...
    'String', 'Extension',...
    'BackgroundColor', dialog_color, 'ForegroundColor', fgcol_text,...
    'FontSize', 12,...
    'Position',...
    [ExtensionTextLeft, ExtensionTextBottom,...
      ExtensionTextWidth, ExtensionTextHeight]);

% եγĥҤ򤹤pop-up menu롣
str = sprintf('|%s', this.public.file_extensions{:});	str(1) = [];
extension_popup_handle = uicontrol('Parent', dialog_handle,...
    'Style', 'popup', 'String', str, 'Value', 1,...
    'BackgroundColor', bgcol_popup, 'ForegroundColor', fgcol_popup,...
    'HorizontalAlignment', 'Left', 'FontSize', 12,...
    'CallBack', {@extension_popup, dialog_handle},...
    'Position',...
    [ExtensionPopupLeft, ExtensionPopupBottom,...
      ExtensionPopupWidth, ExtensionPopupHeight]);


% 'Drive' static text label롣
drive_text = uicontrol('Parent', dialog_handle, 'Style', 'text',...
    'String', 'Drive',...
    'BackgroundColor', dialog_color, 'ForegroundColor', fgcol_text,...
    'FontSize', 12,...
    'Position',...
    [DriveTextLeft, DriveTextBottom, DriveTextWidth, DriveTextHeight]);

% Drive򤹤pop-up menu롣
drive_popup_handle = uicontrol('Parent',dialog_handle, 'Style', 'popup',...
    'String', ' ',...
    'BackgroundColor', bgcol_popup, 'ForegroundColor', fgcol_popup,...
    'HorizontalAlignment', 'Left', 'FontSize', 12,...
    'CallBack', {@drive_popup, dialog_handle},...
    'Position',...
    [DrivePopupLeft DrivePopupBottom DrivePopupWidth DrivePopupHeight]);



% panel롣
if version_value < 704	% MATLAB R14 SP2ΥС
  tmp = uicontrol('Parent', dialog_handle, 'Style', 'Frame',...
      'Position', [PanelLeft PanelBottom PanelWidth PanelHeighth],...
      'BackgroundColor', bgcol_panel, 'ForegroundColor', fgcol_panel);
  panel = [];
  parent = dialog_handle;
  bgcol = get(tmp, 'BackgroundColor');
else	% MATLAB R14ʹߤΥС
  panel = uipanel('Parent', dialog_handle, 'Title', '', 'FontSize', 12,...
      'Units', 'pixels',...
      'Position', [PanelLeft PanelBottom PanelWidth PanelHeighth],...
      'BackgroundColor', bgcol_panel, 'ForegroundColor', fgcol_panel);
  parent = panel;
  bgcol = get(panel, 'BackgroundColor');
end


% 'Directories' static text label롣
uicontrol('Parent', parent, 'Style', 'Text', 'String', 'Directories',...
    'BackgroundColor', bgcol_panel, 'ForegroundColor', fgcol_panel,...
    'HorizontalAlignment', 'Center', 'FontSize', 12,...
    'Position',[DirTextLeft DirTextBottom DirTextWidth DirTextHeight]);

% ǥ쥯ȥɽlist box롣
dir_listbox_handle = uicontrol('Parent', parent,  'Style', 'listbox',...
    'String', '',...
    'BackgroundColor', bgcol_listbox, 'ForegroundColor', fgcol_listbox,...
    'HorizontalAlignment', 'Left', 'FontSize', 12,...
    'CallBack', {@dir_listbox, dialog_handle},...
    'Position', [DirListLeft DirListBottom DirListWidth DirListHeight]);


% 'Files' static text label롣
uicontrol('Parent', parent, 'Style', 'Text', 'String', 'Files',...
    'BackgroundColor', bgcol_panel, 'ForegroundColor', fgcol_panel,...
    'HorizontalAlignment', 'Center', 'FontSize', 12,...
    'Position',...
    [FnameTextLeft FnameTextBottom FnameTextWidth FnameTextHeight]);

% ե̾ɽlist box롣
fname_listbox_handle = uicontrol('Parent', parent,  'Style', 'listbox',...
    'String', '',...
    'BackgroundColor', bgcol_listbox, 'ForegroundColor', fgcol_listbox,...
    'HorizontalAlignment', 'Left', 'FontSize', 12,...
    'CallBack', {@fname_listbox, dialog_handle},...
    'Position',...
    [FnameListLeft FnameListBottom FnameListWidth FnameListHeight]);


% 'Filter' static text label롣
uicontrol('Parent', parent, 'Style', 'text', 'String', 'Filter',...
    'BackgroundColor', bgcol_panel, 'ForegroundColor', fgcol_panel,...
    'HorizontalAlignment', 'Left', 'FontSize', 12,...
    'Position',...
    [FilterFnameTextLeft, FilterFnameTextBottom,...
      FilterFnameTextWidth, FilterFnameTextHeight]);

% 'Filter' edit text롣
filter_str_edit = uicontrol('Parent', parent, 'Style', 'edit', 'String', '',...
    'BackgroundColor', bgcol_edit, 'ForegroundColor', fgcol_edit,...
    'HorizontalAlignment', 'Left', 'FontSize', 12,...
    'CallBack', {@fname_edit, dialog_handle},...
    'String', '*',...
    'Position',...
    [FilterFnameEditLeft,FilterFnameEditBottom,...
      FilterFnameEditWidth, FilterFnameEditHeight]);

% 'Select file' static text label롣
uicontrol('Parent', parent, 'Style', 'text', 'String', 'selected file(s)',...
    'BackgroundColor', bgcol_panel, 'ForegroundColor', fgcol_panel,...
    'HorizontalAlignment', 'Left', 'FontSize', 12,...
    'Position',...
    [SelFnameTextLeft, SelFnameTextBottom,...
      SelFnameTextWidth, SelFnameTextHeight]);

% ե̾ɽedit text롣
sel_fname_edit = uicontrol('Parent', parent, 'Style', 'edit', 'String', '',...
    'BackgroundColor', bgcol_edit, 'ForegroundColor', fgcol_edit,...
    'HorizontalAlignment', 'Left', 'FontSize', 12,...
    'CallBack', {@fname_edit, dialog_handle},...
    'Position',...
    [SelFnameEditLeft,SelFnameEditBottom,...
      SelFnameEditWidth, SelFnameEditHeight]);


% 'Cancel' push button롣
uicontrol('Parent', dialog_handle, 'Style', 'push', 'String', 'Cancel',...
    'FontSize', 12, ...
    'BackgroundColor', bgcol_push, 'ForegroundColor', fgcol_push,...
    'CallBack', {@close_gui, dialog_handle, 'cancel'},...
    'Position', [CancelLeft CancelBottom CancelWidth CancelHeight]);


% 'Done' push button롣
done_push = uicontrol('Parent', dialog_handle, 'Style', 'push',...
    'String', 'OK', 'FontSize', 12,...
    'BackgroundColor', bgcol_push, 'ForegroundColor', fgcol_push,...
    'CallBack', {@close_gui, dialog_handle, 'done'},...
    'Position', [DoneLeft DoneBottom DoneWidth DoneHeight]);


% Save/Load fileDialog window빽¤Τꤹ롣
gui_handles = struct(...
    'dialog', dialog_handle,...
    'current_dir_popup', current_dir_popup_handle,...
    'panel', panel,...
    'extension_popup', extension_popup_handle,...
    'drive_text', drive_text,...
    'drive_popup', drive_popup_handle,...
    'dir_listbox', dir_listbox_handle,...
    'fname_listbox', fname_listbox_handle,...
    'filter_str_edit', filter_str_edit,...
    'sel_fname_edit', sel_fname_edit,...
    'done_push', done_push);

% enable resizing
set(dialog_handle, 'Units', 'normalized', 'Resize', 'on');
h_all = [get(parent, 'children'); get(dialog_handle, 'children')];
for k=1:length(h_all)
    try
        set(h_all(k), 'Units', 'normalized');
    catch
    end
    try
        set(h_all(k), 'FontUnit', 'normalized');
    catch
    end
end
pos = get(dialog_handle, 'Position');
pos(3) = pos(3)*1.2; % width * 1.2
set(dialog_handle, 'Position', pos);
