function [ID, DD] = vb_find_geodesic(Jstart, Jend, xxF, xxD ,Rmax)
% find minimum path along cortical surface
%   [ID, DD] = vb_find_geodesic(Jstart, Jend, xxF, xxD ,Rmax)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%        ûΥϩõ
% ܶ˵ꥹ( xxF ) ȤεΥ( xxD ) Ȥä
% ˱äƺûΥǳ齪ޤǤηϩõ
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUT
%   Jstart	: Υǥå
%   Jend	: Υǥå
%   xxF{i}  : ܶ˵ǥå
%   xxD{i}  : ܶ˵Υ
%   Rmax	: õȾ
% OUTPUT
%   ID  : ϩǥå
%   DD	: ѵΥ
%
% Made by Masa-aki Sato on 2005-1-28
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 르ꥺ  Ƕ˵ꥹȤѤ Tree õ
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%ʬȤ롼Ȥˤ
%ƥ롼ܶ˵νꥹȤϿ
%ꥹȤǤޤǤ˻ƤʤФ
%ȯޤǤѵΥ׻(ϩ˰¸)
%ȯޤǤκûѵΥ
%ѵΥȾ°ˤ򸫤Ĥ
%嵭򿷤롼Ȥˤƣ
%ã齪λ
%Ⱦ°ˤ뿷롼Ȥ̵ʤäȤ˽λ

nextID  = Jstart; 	% ˵ǥåꥹ
prevID  = 0; 		% 1Υǥåꥹ
nextDD	= 0;		% ˵ѵΥꥹ
rootix	= Jstart;  	% 롼ȤΥǥåꥹ
rootd	= 0;  		% 롼ȤѵΥꥹ
itree	= 0;  		% tree number

while itree==0 | ~isempty(rootix),  
    itree	 = itree+1;
    nroot	 = size(rootix,1); % Υ롼
    
    %  : ƤΥ롼Ȥܶ˵
    ixlist = []; % ܶ˵ǥåꥹ
    jplist = []; % 1Υǥå
    ddlist = []; % ܶ˵ؤѵΥꥹ
    
    for i=1:nroot, 
    	iroot  = rootix(i);	% 롼ȤΥǥå
	    ixlist = [ixlist; xxF{iroot}]; 				% ܶ˵ǥå
	    ddlist = [ddlist; xxD{iroot} + rootd(i) ];	% ܶ˵ؤѵΥ
	    newnum = length(xxF{iroot});
	    jplist = [jplist; iroot(ones(newnum,1))];	% 1Υǥå
    end;
    
    % ιʤ
    ixuniq = unique(ixlist);  			% ʣǥå
    nextix = vb_setdiff2(ixuniq,nextID);  	% õѤߤΥǥå

    % õǥå
    nextix = nextix(:);
    Nnext  = length(nextix);
    nextd  = zeros(Nnext,1);
    prevj  = zeros(Nnext,1);
    
    for i=1:Nnext,  % Loop of new dipoles
    	% ixlist  nextix(i) ǥå
    	% Jstart  nextix(i) ʣηϩб
        jx = find( nextix(i)==ixlist );
        
        % nextix(i) ؤκûѵΥõ
        [dmin ,jmin] = min(ddlist(jx)); 
        % ûѵΥ
        nextd(i) = dmin;
        % 1Υǥå
        prevj(i) = jplist(jx(jmin));
    end
    
    % ãå
    jfinal  = find(nextix == Jend);
    
    if isempty(jfinal)
	    % Ⱦ°θõ
	    okix	= find(nextd<Rmax); % Ⱦ°θõ
	    rootix	= nextix(okix);  	% Ⱦ°θ(Υ롼)
	    rootd	= nextd(okix);  	% κûѵΥ
	    prevj   = prevj(okix);		% 1Υǥå
	
	    % ˵ꥹ
	    nextID = [nextID ; rootix ];% ˵ꥹ
	    prevID = [prevID ; prevj ];	% 1Υǥå
	    nextDD = [nextDD ; rootd  ];% ûѵΥ
	else
	    nextID = [nextID ; Jend ];% ˵ꥹ
	    prevID = [prevID ; prevj(jfinal)];	% 1Υǥå
	    nextDD = [nextDD ; nextd(jfinal)];	% ûѵΥ
	    break;
	end
end

ID = [];
DD = [];

Nend = length(nextID);
iend = Nend;
% Backtrack
% 1ΥǥåȤ˽鳫طϩõ

for n=1:Nend
	ID    = [ID; nextID(iend)];
	DD    = [DD; nextDD(iend)];
	jpre  = prevID(iend);
	
	if jpre == 0, break; end;
	
	iend  = find( jpre == nextID );
end	

ID = flipud(ID);
DD = flipud(DD);
