function [curr_type, file_type] = vb_load_current_type(currfile)
% load current type
%
% USAGE:
%  [curr_type, file_type] = vb_load_current_type(currfile)
%
% --- INPUT:
%  currfile  - current file name
% --- OUTPUT:
%  curr_type - current type 
%            = 0 : J-current : original vertex current [Default]
%            = 1 : Z-current : internal current 
%                              correspond to locally spread source
%  file_type : file type
%  file_type = 0: single file
%  file_type = 1: parent file with trial files
%  
% --- History
% 2009-07-30 Taku Yoshioka
%  Previous version did not check if 'jactdir' is empty or not. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

load(currfile)

if exist('Zact','var') 
	curr_type = 1;
	if isfield(Jinfo,'jactdir') & ~isempty(Jinfo.jactdir), 
		file_type = 1;
	else
		file_type = 0;
	end
	
elseif exist('Jact','var') 
	curr_type = 0;
	if exist('JactInfo','var')
		file_type = 1;
	else
		file_type = 0;
	end
elseif exist('J','var')
	curr_type = 0;
	file_type = 0;
else
	curr_type = '';
	file_type = '';
end


return
