function [Jact,ix_act] = vb_load_current_j(currfile,ave_mode,trial,ix_area);
% load estimated current
%
% USAGE:
%  [Jact,ix_act] = vb_load_current_j(currfile,ave_mode,trial,ix_area)
%
% --- INPUT:
%  currfile  - current file name
% --- Optional INPUT:
%  ave_mode : trial average mode
%          = ON  : trial average is done
%          = OFF : No trial average
%  trial   : trial number to load 
%            if empty, all trials are loaded
%  ix_area : (absolute) vertex index to load
%            if empty, all vertices are loaded
% --- OUTPUT:
% ix_act  : Vertex index corresponding to current
% Jact    : current in focal region (J-current)
%   Jact(Nact,Nsample)          for ave_mode = ON 
%   Jact(Nact,Nsample,Ntrials)  for ave_mode = OFF
%     Nact     = Lact * Nvact,  Nvact = length(ix_act)
%     Nsample  : # of time sample, 
%     Ntrials  : # of trials in all session]
%
%   Jact( n + Nvact*(i-1), t, :) 
%    current at the vertex 'ix_act(n)', 'i-th' direction, time index 't'
%
%   Time sample in MEG data : t_meg = Tsample(t)
%   Time (ms)   in MEG data : t_ms  = (t_meg - Pretrigger)*(1000/SampleFreq)
%
%
% 2007-3-5 Masa-aki Sato
% 2008-7-9 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('ave_mode','var'), ave_mode = ON; end;
if ~exist('trial','var'), trial = []; end;
if ~exist('ix_area','var'), ix_area = []; end;

load(currfile)

if ~exist('Jact','var') 
	if exist('J','var')
		% ver 0.1
		% save(parm.currfile,'J','ix0');
		Jact = J;
		ix_act = ix0;
	else
		error(['There is no Jact in ' currfile])
	end
end

[NJ, T, Ntrial] = size(Jact);
if isempty(trial), trial = 1:Ntrial; end;

% find selected area index
Jinfo = vb_load_current_info(currfile);
[ix_act, jx_act] = vb_current_area_info(Jinfo,ix_area);

Jact = Jact(jx_act,:,trial);

if ave_mode==ON,
	Jact = mean(Jact,3);
end

