function [nextDD,nextIX] = vb_load_cortex_neighbour(brainfile, coord_type) 
% Load neighbour data of the brain file. 
% ---
% function [nextDD,nextIX] = vb_load_cortex_neighbour(brainfile) 
%
% --- Input
% brainfile: .brain.mat file
% --- Optional input
% coord_type : load data specification 
%              = 'std' : standard brain (nextIX, nextDD, xx).  (Default)
%                        If the specified brainfile is V1 format, 
%                          Individual brain data is loaded.
%              = 'subj': Individual brain (subj.nextIX, nextDD).
% --- Output
% nextDD{n}   : Distance to neighbour points at n-th vertex
% nextIX{n}   : Indices of neighbour points at n-th vertex
%
% --- History
% 2005-08-19 Taku Yoshioka
% 2017-03-15 rhayashi       Added coord_type
% ---
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('coord_type', 'var')
    coord_type = 'std';
end

switch(lower(coord_type))
    case 'std'
        load(brainfile,'nextDD','nextIX');
    case 'subj'
        warning('off', 'MATLAB:load:variableNotFound');
        load(brainfile, 'subj');
        warning('on',  'MATLAB:load:variableNotFound');
        if exist('subj', 'var')
            % V2.x format
            if ~isfield(subj, 'nextDD')
                % V2.0 format
                load(brainfile, 'nextDD', 'nextIX');
            else
                % V2.1 format
                nextDD = subj.nextDD;
                nextIX = subj.nextIX;
            end
        else
            % V1 format
            load(brainfile,'nextDD','nextIX');
        end
    otherwise
        error('Unknown coord_type is specified.');
end
