function [Norient, normal_mode, basis_parm] = vb_load_basis_info(basisfile);
% Get information of basis (leadfileld)
% [Norient, normal_mode] = vb_load_basis_info(basisfile);
% [Norient, normal_mode, bem_mode] = vb_load_basis_info(basisfile);
% --- Input
% basisfile : leadfileld basis file name
% --- Output
% Norient     : number of independent current orientation 
% normal_mode : normal average mode
% basis_parm  : leadfield calculation parameters
%
% changed 2007-2-25 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

load(basisfile,'basis_parm');

global vbmeg_inst;
const = vbmeg_inst.const;

if exist('basis_parm','var') 
	% ver.0.30
    Norient = basis_parm.Basis_mode;
    
    if isfield(basis_parm,'normal_mode')
    	% ver.0.5
    	normal_mode = basis_parm.normal_mode;
    else
    	% up to ver.0.4 
    	normal_mode = const.NORMAL_ADJACENT_MEAN;	% ˡʿ
    	basis_parm.normal_mode = normal_mode;
    end
else                   
    load(basisfile,'L*');
	% ver.0.1
    if exist('Ldipole','var'),  Norient = Ldipole; end;
	% ver.0.2
    if exist('L','var'),  Norient = L; end;
   	normal_mode = const.NORMAL_ADJACENT_MEAN;	% ˡʿ
   	
   	basis_parm.normal_mode = normal_mode;
    basis_parm.Basis_mode = Norient;
end

    
