function	CW = vb_smooth_filter_norm(parm,Rradius,Rmax,Iextract)
% smooth filter with normalization
%  CW = vb_smooth_filter_norm(parm,Rradius,Rmax,Iextract)
%
% Ver 1.0 written by M. Sato  2003-4-15
% Modified by Taku Yoshioka 2003-08-12
%
% Iextract: ʬǾǥΥǥå
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

dir = parm.dir ;
file = parm.file;

% ʬǾǥζ˵
load([dir.brain file.brain],'nextDD','nextIX');
[nextIXNew,nextDDNew] = ...
    vb_reduce_neighbor_data(Iextract,nextIX,nextDD);
nextDD = nextDDNew;
nextIX = nextIXNew;
clear nextDDNew nextIXNew;

%%%%%%% Smoothing Filter calculation %%%%%%%
Nvertex = size(nextIX,1);

val 	= [];			% Filter value
ipoint	= [];			% Center point index
inext	= [];			% Neighbor index

if Rradius > 0,
  for i=1:Nvertex,
    dd0 = nextDD{i};		% Neighbor distance
    inx = find( dd0 <= Rmax );	% Find neighbor within Rmax
    
    ix	= nextIX{i}(inx);	% Neighbor index within Rmax
    dd	= dd0(inx); 		% Distance from point-i to 'ix'
		
    ipoint = [ ipoint ; repmat( i ,[length(ix) 1] ) ];
    inext  = [ inext  ; ix ];
    val    = [ val    ; exp( - (dd/Rradius).^2 ) ];
  end;

  CW = sparse( ipoint , inext , val , Nvertex, Nvertex, length(ipoint) ) ;
  CW = spdiags( ones(Nvertex,1), 0, CW);
  
  % Symmetrize matrix by shorter path length
  CW = max( CW , CW' );
  wnorm = sqrt(sum( CW.^2 , 2));

  % Normalize filter matrix
  CW = CW./repmat( wnorm ,[ 1 Nvertex ]);
else
  CW = sparse(eye(Nvertex,Nvertex));
end;

