function	[Vindx, Iremove, FLbig, FRbig] = ...
                    vb_remove_corpus(F,V,nextIX,nextDD,Rmax,Rstep,Dmax)
% Find central corpus callosal region to remove these region
%  [Vindx,Iremove] = vb_remove_corpus(F,V,nextIX,nextDD,Rmax,Rstep,Dmax)
% 
% Vindx   : Vertex index for cortex model after removing central region
% Iremove : Vertex index for central region
% FLbig    : Triangle index for central corpus callosal region (Left brain)
% FRbig    : Triangle index for central corpus callosal region (Right brain)
% commissure
%
% 2005-3-28  by M. Sato
%
% طʳưѤ˺ǾǾնĺĺǥå
%
% 
% ޤϤ Dmax 礭ĹĻѷ
%     濴նǾʬбĺ
% 
% RmaxϺǽΰ褫ɤΰ礵뤫Ⱦ
%     ˱äΥ16mm٤׻ƤʤΤǡ
%     Rmaxˤʤޤǥ򷫤֤
%     Rstep1Υ˻ѤȾ¡
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin<5, Rmax  = 0.04;end;
if nargin<6, Rstep = 0.01;end;
if nargin<7, Dmax  = 0.02;end;

Nmax  = ceil(Rmax/Rstep);

% Process left and right separately
FL = F.F3L;
FR = F.F3R;

% Find triangle with large length in corpus callosal
FLindx = vb_find_big_triangle(FL,V,Dmax);
FRindx = vb_find_big_triangle(FR,V,Dmax);

FLbig   = FL(FLindx,:);
FRbig   = FR(FRindx,:);
Lremove = unique(FLbig(:));
Rremove = unique(FRbig(:));

% Extend remove region by erosion
for n=1:Nmax
	Lremove = vb_fat_area(Lremove, Rstep, nextIX, nextDD);
	Rremove = vb_fat_area(Rremove, Rstep, nextIX, nextDD);
end

NV    = size(V,1);

% Remove index
Iremove = [Lremove; Rremove];
% 
flag = zeros(NV,1);
flag(Iremove) = 1;

% Remaining region index
Vindx = find( flag == 0 );
