function std_brain_file = vb_parent_std_brain_file_get(brain_file)
% get template standard brain file path of specified brain_file.
% [Usage]
%    std_brain_file = vb_parent_std_brain_file_get(brain_file);
%
% [Input]
%        brain_file : VBMEG Cortical model file(.brain.mat)
%
% [Output]
%    std_brain_file : Template standard brain path of brain_file.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if nargin ~= 1
    error('Please check function usage.');
end
if exist(brain_file, 'file') ~= 2
    error('Specified file not found.');
end

%
% --- Main Procedure
%
load(brain_file, 'brain_parm');
if ~exist('brain_parm', 'var')
    vb_disp('Specified brain file is created by VBMEG v1.');
    std_brain_file = brain_file;
    return;
else
    [a] = vb_set_icbm152(brain_parm.Nvertex);
    child_dir = strrep(a.brain_file, '.brain.mat', '');
    std_brain_file = fullfile(a.std_dir, child_dir, a.brain_file);
    if exist(std_brain_file, 'file') ~= 2
        error('Original standard brain not found in VBMEG %s', std_brain_file);
    end
end
