function  normal_stat = vb_original_normal_statics(proj_root,brain_parm,BV_index)
% Find original vertex near the cortical vertex
%  normal_stat = vb_original_normal_statics(proj_root,brain_parm,BV_index)
% --- Input
% proj_root
% brain_parm
%  brain_parm.R_normal : Max radius of neighbor search
% BV_index  : original vertex index in BV/FS corresponding to brain.
% --- Output
% normal_stat.neighbor_org : original brain neighbor index list
% normal_stat.normal_org   : original brain normal vector
% normal_stat.neighbor_dd  : mean neighbor distance list
% normal_stat.neighbor_area : neighbor_area list
%
% [history]
% M. Sato  2015-12-14 ver.2.0
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if isempty(proj_root)
	brain_file  = [brain_parm.brain_file];
else
	brain_file  = [proj_root filesep brain_parm.brain_file];
end

% Max radius of neighbor search
if isfield(brain_parm,'R_normal')
	Rmax = brain_parm.R_normal; 
else
	Rmax = 0.003;	% 3mm
end

EPS = 1e-10;
%
% --- Load original brain
%
vb_disp('Calculate original normal statics')
vb_disp('Load original brain')
[V0L,F0L,n0L,V0R,F0R,n0R] = vb_load_orig_brain_surf(brain_parm);

%tic
% ----- This is done in vb_load_orig_brain_surf for freesurfer
%[F0L, V0L, n0L] = vb_out_normal_surf(F0L,V0L);
%[F0R, V0R, n0R] = vb_out_normal_surf(F0R,V0R);
%
%vb_disp(sprintf('%f[sec]',toc));

%
% --- SPM cordinate in [m]
%
vb_disp('Change coordinate to [m] ');

V0L = V0L/1000;
V0R = V0R/1000;

NV0L  = size(V0L,1);
NV0R  = size(V0R,1);
NV0   = NV0L + NV0R;

%
% --- Check normal direction outward
%     normal vector for disconnected vertex is set to zero
vb_disp('check normal direction outward: ')

%
% ---- Check closed surface by solid_angle/(2*pi) = 1
%
omega  = vb_solid_angle_check(V0L,F0L);
vb_disp(sprintf('Left solid_angle/(2*pi) = %5.3f',omega));
if abs(omega - 1) > EPS,
	vb_disp('Surface is not closed ');
end
omega  = vb_solid_angle_check(V0R,F0R);
vb_disp(sprintf('Right solid_angle/(2*pi) = %5.3f',omega));
if abs(omega - 1) > EPS,
	vb_disp('Surface is not closed ');
end

%
% ---- Check abnormal direction
%
NLxx = sum( (sum(n0L.^2,2) - 1) < EPS );
if NLxx ~= NV0L,
	vb_disp(sprintf('# of left abnormal normal vector (%d)',NV0L - NLxx));
end
NRxx = sum( (sum(n0R.^2,2) - 1) < EPS );
if NRxx ~= NV0R,
	vb_disp(sprintf('\n# of right abnormal normal vector (%d)',NV0R - NRxx));
end

%
% ---- Load Original vertex index for reduced cortex
%
indxL = BV_index.Left;
indxR = BV_index.Right;

NL = length(indxL);
NR = length(indxR);

if min(indxR) > NV0L,
	indxR = indxR - NV0L;
end

%-------------------------------------------------------
% Search neighbor points along cortex sheet 
% and calculate normal direction statistics
%-------------------------------------------------------

neighbor = cell(NL+NR,1);
neighbor_dd = zeros(NL+NR,1);
neighbor_area = zeros(NL+NR,1);

%
% --- Make neighbor list of original brain (Left)
%
tic
vb_disp_nonl('Find neighbor index (Left): ')
[xxDL,xxFL, xxTL]   = vb_next_distance( F0L, V0L ); 
vb_disp(sprintf('%f[sec]',toc));

% Vertex area
[xxAL] = vb_calc_patch_area(V0L, F0L, xxTL);
vb_disp(':Done')

vb_disp_nonl('Make neighbor list of original brain (Left): ')
tic

prg_all = NL;
prg = 0;
Ndisp = fix(prg_all/20);

% --- Search neighbor points along cortex sheet 
for n=1:NL
	[Vindx, dd] = vb_find_neighbor(Rmax, indxL(n), xxFL, xxDL );
	neighbor{n} = Vindx;
	
	% neighbor mean distance
	neighbor_dd(n) = mean(dd);
	% neighbor area
 	neighbor_area(n) = sum(xxAL(Vindx));
	
	if mod(n,Ndisp)==0, 
	  for ii=1:15; vb_disp_nonl(sprintf('\b')); end
	  vb_disp_nonl(sprintf('%3d %% processed',ceil(100*(prg/prg_all))));
	end
	prg = prg+1;
end
vb_disp_nonl(sprintf(' %f[sec]\n',toc));

%
% --- Make neighbor member list of original brain (Right)
%
tic
vb_disp_nonl('Find neighbor index (Right): ')
[xxDR,xxFR,xxTR]   = vb_next_distance( F0R, V0R ); 
vb_disp(sprintf('%f[sec]',toc));

% Vertex area
[xxAR] = vb_calc_patch_area(V0R, F0R, xxTR);
vb_disp(':Done')

vb_disp_nonl('Make neighbor list of original brain (Right): ')
tic

prg_all = NR;
prg = 0;
Ndisp = fix(prg_all/20);

% --- Search neighbor points along cortex sheet 
for n=1:NR
	[Vindx, dd] = vb_find_neighbor(Rmax, indxR(n), xxFR, xxDR );
	neighbor{n + NL} = Vindx + NV0L;
	
	% neighbor mean distance
	neighbor_dd(n + NL) = mean(dd);
	% neighbor area
 	neighbor_area(n + NL) = sum(xxAR(Vindx));
	
	if mod(n,Ndisp)==0, 
	  for ii=1:15; vb_disp_nonl(sprintf('\b')); end
	  vb_disp_nonl(sprintf('%3d %% processed',ceil(100*(prg/prg_all))));
	end
	prg = prg+1;
end
vb_disp_nonl(sprintf(' %f[sec]\n',toc));

% neighbor info
normal_stat.neighbor_org = neighbor;
normal_stat.neighbor_dd  = neighbor_dd;
normal_stat.neighbor_area = neighbor_area;

% Original vertex, normal & patch
normal_stat.normal_org = [n0L; n0R];

%normal_stat.V0L = V0L;
%normal_stat.V0R = V0R;
%normal_stat.F0L = F0L;
%normal_stat.F0R = F0R;

% Original dimension
normal_stat.Nvertex    = NL+NR;
normal_stat.NvertexL   = NL;
normal_stat.NvertexR   = NR;
normal_stat.Nvertex0   = NV0;
normal_stat.NvertexL0  = NV0L;
normal_stat.NvertexR0  = NV0R;

return
