function	[xxD, xxF, xxT, xxN] = vb_next_distance(F,V)
% Search next-point index and distance
%   [xxD, xxF, xxT, xxN] = vb_next_distance(F,V)
%
% xxD{n} : ĺ n  ܶ˵ Ȥ Υ
% xxF{n} : ĺ n  ܶ˵ĺֹ
% xxT{n} : ĺ n  ܣֹ
% xxN(n) : ĺ n  ܶ˵ĺ
%
%
% M. Sato  2003-3-15
% M. Sato  2017-3-10
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Npoint = size(V,1);  		% number of dipoles
Npatch = size(F,1);  		% number of patch
xxD = cell(Npoint,1); 
xxF = cell(Npoint,1); 
xxT = cell(Npoint,1); 
xxN = zeros(Npoint,1);

% ̤˴ؤ롼
for j=1:Npatch,
    % ̤ĺǥå
    k = F(j,:); 
    
    % ĺζ˵ꥹȤ¾ĺä
	xxF{k(1)} = [ xxF{k(1)} ; k(2) ; k(3)];
	xxF{k(2)} = [ xxF{k(2)} ; k(3) ; k(1)];
	xxF{k(3)} = [ xxF{k(3)} ; k(1) ; k(2)];
	
    % ĺΣ̥ꥹȤˣֹä
	xxT{k(1)} = [ xxT{k(1)} ; j ];
	xxT{k(2)} = [ xxT{k(2)} ; j ];
	xxT{k(3)} = [ xxT{k(3)} ; j ];
end;

for i=1:Npoint,
	% ˵ꥹȤνʣ
	nextix = unique(xxF{i});
	xxF{i} = nextix;
	xxN(i) = length(nextix);
	
	Va = V(i,:);
	Vb = V(nextix,:);
	
	% Distance from vertex i to next points xxF{i}
	%dd = (Va(1)-Vb(:,1)).^2 +(Va(2)-Vb(:,2)).^2 +(Va(3)-Vb(:,3)).^2 ;
	dd = sum(vb_repadd(Vb, -Va).^2, 2);
	xxD{i} = sqrt(dd);
end
