function	xxn = vb_mean_normal_vector_1(Indx,F,V,xx)
%    xxn     : ʿˡ = ʬμ̤ˡʿ
%
%   Indx     : ˡ׻ݡĺֹ
%  V(n, 1:3) : ݡΰ
% xx(n, 1:3) : ݡ(nx,ny,nz)
%
% Originaly written by S.Kajihara
% Ver 1.0  modified by M. Sato  2003-3-15
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

F		  = F.F3;

Npoint	  = size(V,1);  		% number of dipoles
Npatch	  = size(F,1);  		% number of patch
xxn 	  = zeros(Npoint,3);	% Mean normal vector
Flg 	  = zeros(Npoint,1);	
Flg(Indx) = 1;					% Flag for dipole index

xxk 	  = zeros(1,3);
nnk 	  = zeros(1,3);

for i=1:Npatch,
    % ̤ĺǥå
    k	  = F(i,:); 
    
    if sum( Flg(k) )==0,  continue; end ;
    
    % ̤ˡ٥ȥ
    nnk   = cross( V(k(2),:)-V(k(1),:) , V(k(3),:)-V(k(1),:) );

    % Normalization
    nnk   = nnk./norm(nnk);		
    
    % ̤ˡ٥ȥ 'nnk' ȸƱ
    % ĺˡ٥ȥ 'xx' ο
    xdot  = sum( xx(k,:) .* repmat(nnk ,[3,1]) ,2);
    xsign = sum(sign(xdot));
    nnk   = sign(xsign)*nnk;

	% ˡʿ
    xxn(k,:) = xxn(k,:) + repmat(nnk ,[3,1]);
end

xxn  = xxn(Indx,:);
xxn2 = sqrt(sum(xxn.^2 , 2));
xxn  = xxn./repmat(xxn2, [1 3]);
