function [V,F,xx,BV_index,Vinfo] = vb_make_brain_data2(brain_parm)
% Make cortex data from BrainVoyager/FreeSurfer files
%   [V,F,xx,ORG_index,Vinfo] = vb_make_brain_data2(brain_parm)
%
% ---
% BrainVoyagerޤFreeSurferǾǡβ٤򲼤Ǿǡ
%
%--- Input
%
% brain_parm        : structure with following field
%  (used for BrainVoyager files)
%    .BV_left_file   : Brain-Voyager left  surface file
%    .BV_right_file  : Brain-Voyager right surface file
%
%  (used for FreeSurfer files)
%    .FS_left_file   : FreeSurfer left surface file
%    .FS_right_file  : FreeSurfer right surface file
%
%    .analyze_file   : MRI analyze file
%    .Nvertex        : Total number of vertices of the right and left brain
%                      after reducing original(BV/FS) model.
%                      (Priority: Nvertex>reduce_ratio)
%    .reduce_ratio   : ratio of reducing vertex points
%         BVǥ뤫VBMEGǾǥȤĺκ︺Ψ
%    .N_step         : Division number in searching match points
%         ĺбõZʬ
% 
%--- Output
% 
% V    : Cortical vertex point cordinate (SPM_Right_m) [Nvertex, 3]
%          ĺ  ĺο, 3
% xx   : Normal vector to cortical surface   [Nvertex, 3]
%           ĺˡȰ֡ ĺο, 3
% F      : Patch index structure
%           (3ѷ)룳Ĥĺֹ ( ̤ο, 3)  
%  .F3R	 : Right cortex
%  .F3L	 : Left  cortex
%  .F3	 : Left + Right
% BV_index  : original vertex index in BV corresponding to brain
%    .Left     : Left  brain
%    .Right    : Right brain
% Cortex area index of original FreeSurfer surface
% BV_index.cortexL 
% BV_index.cortexR 
% Vinfo        : Vertex dimension structure
%   .Ndipole   : # of vertex
%   .NdipoleL  : # of vertex in Left cortex
%   .Npatch    : # of patch
%   .Coord     = 'SPM_Right_m';
% Cortex area index of 'V'
% Vinfo.cortexL = 
% Vinfo.cortexR = 
%
% Originaly written by S.Kajihara
% Ver 1.1  modified by M. Sato  2003-4-15
%
% Modified by Taku Yoshioka
% 2003-07-11 
% ե¸ǡ¤ѹ
% å򾯤ѹ
% 2003-07-29
% ɸѴΥեåȤؤ褦ѹ
% 2003-10-08
% MRI-Voxelɸǡ¸(λ)
%
%
% 2005-03-20 Modified by TY
%
% Ver 2.0  modified by M. Sato  2005-4-8
% ɸϤSPMɸѴ
%   Analyze ե뤬ɬ
%   (DICOM ᡼ե)
%
% modified by M. Sato  2005-8-1
%   Vinfo ɲ
% modified by M. Sato  2005-8-9
%   ѥ᥿ѿ̾ľѹ
% modified by M. Sato  2006-7-21
%   use BV file load function
% 2010-05-28 Taku Yoshioka
%  Minor change (verbose level support)
% 2010-08-23 rhayashi
%  support Nvertex parameter.
% 2017-03-14 rhayashi
%  Add Vinfo.(cortexL/cortexR) and BV_index.(cortexL/cortexR)

% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% V0L/R  Brain-Voyager coordinate
% n0L/R  unit vector 
% FOL/R  triangle patch
global vbmeg_inst;
const = vb_define_verbose;

vb_disp('Load original brain');
[V0L,F0L,n0L,V0R,F0R,n0R] = vb_load_orig_brain_surf(brain_parm);
% V0L/R  vertex coordinate (SPM_Right mm)
% n0L/R  unit vector 
% FOL/R  triangle patch

% Extract cortex area index
vb_disp('Extract cortex area index');

[Vindex] = vb_extract_cortex(V0L,F0L,V0R,F0R,brain_parm,0);

%
% --- Redeuce patchs
%
tic;
vb_disp('Reduce cortical vertices ');

R = 1.0;
if isfield(brain_parm, 'Nvertex') && ~isempty(brain_parm.Nvertex) &&...
   isnumeric(brain_parm.Nvertex)
    % Number of verticies after reducing
    N = brain_parm.Nvertex;
    if((size(V0L, 1) + size(V0R, 1)) < N)
        vb_disp(['brain_parm.Nvertex is larger than original model''s one.'...
                 'No reduction is applied.'], const.VERBOSE_LEVEL_WARNING);
    else
        R = N;
        vb_disp(sprintf('Nvertex = %d is applied.', brain_parm.Nvertex));
    end
elseif isfield(brain_parm, 'reduce_ratio') && ...
       isnumeric(brain_parm.reduce_ratio)
    R = brain_parm.reduce_ratio;
    vb_disp(sprintf('reduce_ratio = %.2f is applied.', ...
            brain_parm.reduce_ratio));
end

[F3L,V3L] = vb_reducepatch( F0L, V0L, R ); % 0 < R < 1: ratio
[F3R,V3R] = vb_reducepatch( F0R, V0R, R ); % R > 1   : number of verticies

vb_disp(sprintf('%f [sec]',toc));

%
% ---  Find original vertex point in BV-model corresponding to reduced model
%
tic;
vb_disp_nonl('Find original point corresponding to reduced model: ');

IndxL = vb_find_match_point( V0L, V3L, brain_parm.N_step );
IndxR = vb_find_match_point( V0R, V3R, brain_parm.N_step );

% ---  Normal vector obtained from original BV-model
n3L = n0L(IndxL,:);
n3R = n0R(IndxR,:);


% Vertex number of reduced model
NdipoleL = size(V3L,1);
NdipoleR = size(V3R,1);
Ndipole  = NdipoleL + NdipoleR;

F3R = F3R + NdipoleL;
F3  = [F3L ; F3R];
xx  = [n3L ; n3R]; 

% Normalize normal vectors
nn = sqrt(sum(xx.^2 ,2)); 
nn = max( nn, eps);
xx = xx./repmat(nn ,[1 3]);

vb_disp(sprintf('%f[sec]',toc));

NdipoleL0 = size(V0L,1);
NdipoleR0 = size(V0R,1);

%
% --- SPM cordinate in [m] , Normal vector is outward.
%
tic;
vb_disp_nonl('Change coordinate to [m]: ');
V  = [V3L ; V3R]/1000;

% triangle patch index for left/right brain
Npatch     = size(F3,1);
F.F3	   = F3;
F.F3R	   = F3R;
F.F3L	   = F3L;
F.NdipoleL = NdipoleL;

% BrainVoyager vertex index corresponding to reduced brain 'V'
BV_index.Left  = IndxL; 
BV_index.Right = IndxR + NdipoleL0;

% Cortex area index of original FreeSurfer surface
BV_index.cortexL = Vindex.cortexL;
BV_index.cortexR = Vindex.cortexR + NdipoleL0;

% Dimensional info
Vinfo.Ndipole   = Ndipole;
Vinfo.NdipoleL  = NdipoleL;
Vinfo.NdipoleR  = NdipoleR;

Vinfo.Ndipole0  = NdipoleL0 + NdipoleR0;
Vinfo.NdipoleL0 = NdipoleL0;
Vinfo.NdipoleR0 = NdipoleR0;
Vinfo.Npatch    = Npatch;
Vinfo.Coord     = 'SPM_Right_m';
clear V3L V3R n3L n3R

[cortexL, cortexR] = vb_cortex_area_index(Vinfo, Vindex, IndxL, IndxR);
Vinfo.cortexL = cortexL;
Vinfo.cortexR = cortexR;

vb_disp(sprintf('%f[sec]',toc));
