function [V,F,xx,BV_index,Vinfo] = vb_make_brain_data(brain_parm);
% Make cortex data from BrainVoyager/FreeSurfer files
%   [V,F,xx,ORG_index,Vinfo] = vb_make_brain_data(brain_parm)
%
% ---
% BrainVoyagerޤFreeSurferǾǡβ٤򲼤Ǿǡ
%
%--- Input
%
% brain_parm        : structure with following field
%  (used for BrainVoyager files)
%    .BV_left_file   : Brain-Voyager left  surface file
%    .BV_right_file  : Brain-Voyager right surface file
%
%  (used for FreeSurfer files)
%    .FS_left_file   : FreeSurfer left surface file
%    .FS_right_file  : FreeSurfer right surface file
%    .FS_xfm_file    : Talairach transformation file
%
%    .analyze_file   : MRI analyze file
%    .reduce_ratio   : ratio of reducing vertex points
%         BVǥ뤫VBMEGǾǥȤĺκ︺Ψ
%    .N_step         : Division number in searching match points
%         ĺбõZʬ
% 
%--- Output
% 
% V    : Cortical vertex point cordinate (SPM_Right_m) [Nvertex, 3]
%          ĺ  ĺο, 3
% xx   : Normal vector to cortical surface   [Nvertex, 3]
%           ĺˡȰ֡ ĺο, 3
% F      : Patch index structure
%           (3ѷ)룳Ĥĺֹ ( ̤ο, 3)  
%  .F3R	 : Right cortex
%  .F3L	 : Left  cortex
%  .F3	 : Left + Right
% BV_index  : original vertex index in BV corresponding to brain
%    .Left     : Left  brain
%    .Right    : Right brain
% Vinfo        : Vertex dimension structure
%   .Ndipole   : # of vertex
%   .NdipoleL  : # of vertex in Left cortex
%   .Npatch    : # of patch
%   .Coord     = 'SPM_Right_m';
%
% Originaly written by S.Kajihara
% Ver 1.1  modified by M. Sato  2003-4-15
%
% Modified by Taku Yoshioka
% 2003-07-11 
% ե¸ǡ¤ѹ
% å򾯤ѹ
% 2003-07-29
% ɸѴΥեåȤؤ褦ѹ
% 2003-10-08
% MRI-Voxelɸǡ¸(λ)
%
%
% 2005-03-20 Modified by TY
%
% Ver 2.0  modified by M. Sato  2005-4-8
% ɸϤSPMɸѴ
%   Analyze ե뤬ɬ
%   (DICOM ᡼ե)
%
% modified by M. Sato  2005-8-1
%   Vinfo ɲ
% modified by M. Sato  2005-8-9
%   ѥ᥿ѿ̾ľѹ
% 2008-10-16 Taku Yoshioka
%   Non-XFM file support for FreeSurfer ver. 4.0
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

error('This function is a canditate to be removed, but invoked.');

global vbmeg_inst;
define = vbmeg_inst.const;

% Define constant
TRANS_COORDINATE = 0;
TRANS_NORMAL     = 1;

% V0L/R  Brain-Voyager coordinate
% n0L/R  inward-normal unit vector 
% FOL/R  triangle patch
tic; 
if isfield(brain_parm,'BV_left_file') & ...
      ~isempty(brain_parm.BV_left_file),
  %
  % --- Brain-Voyager coordinate
  %
  % [Left-hand coordinate]
  % X:Front(0) -> Back(255)
  % Y:Top(0)   -> Bottom(255)
  % Z:Right(0) -> Left(255)
  fprintf('\n--- Make brain model using BrainVoyager SRF files ');
  filetype = 'BrainVoyager'; 
  
  Srf = vb_ScriptLoadSRF(brain_parm.BV_left_file);
  V0L = [Srf.VertexX, Srf.VertexY, Srf.VertexZ]; 
  n0L = [Srf.NormalX, Srf.NormalY, Srf.NormalZ]; 
  F0L = Srf.Triangles+1;

  Srf = vb_ScriptLoadSRF(brain_parm.BV_right_file);
  V0R = [Srf.VertexX, Srf.VertexY, Srf.VertexZ]; 
  n0R = [Srf.NormalX, Srf.NormalY, Srf.NormalZ]; 
  F0R = Srf.Triangles+1;
elseif isfield(brain_parm,'FS_left_file') & ...
      ~isempty(brain_parm.FS_left_file), 
  fprintf('\n--- Make brain model using FreeSurfer .asc files ');
  filetype = 'FreeSurfer'; 
  
  [V0L,F0L] = vb_fs_load_surface(brain_parm.FS_left_file,...
			      brain_parm.FS_xfm_file,1.0);
  [V0R,F0R] = vb_fs_load_surface(brain_parm.FS_right_file,...
			      brain_parm.FS_xfm_file,1.0);

  [tmp1,tmp2,n0L] = vb_out_normal(F0L,V0L); 
  [tmp3,tmp4,n0R] = vb_out_normal(F0R,V0R);
  n0L = -1*n0L; 
  n0R = -1*n0R; 
  
  if size(tmp1,1)~=size(F0L,1) | size(tmp2,1)~=size(V0L,1) | ...
	size(tmp3,1)~=size(F0R,1) | size(tmp4,1)~=size(V0R,1), 
    error(['There are some isolated pathces in the FreeSurfer ' ...
	   'cortical model.']);
  end
end
fprintf('%f[sec]\n',toc);

switch filetype
 case 'BrainVoyager', 
  %
  % --- MRI-Voxel coordinate   
  %
  % [Right-hand coordinate]
  % X:Front(1) -> Back(256)
  % Y:Top(1)   -> Bottom(256) 
  % Z:Left(1)  -> Right(191) 
  %
  tic;
  fprintf('--- Coordinate transformation (BV to VOX) ');

  [Vdim, Vsize] = analyze_hdr_read(brain_parm.analyze_file);

  V2L = vb_bvoyger_to_vox(V0L,Vdim,Vsize,TRANS_COORDINATE);
  V2R = vb_bvoyger_to_vox(V0R,Vdim,Vsize,TRANS_COORDINATE);

  n2L = vb_bvoyger_to_vox(n0L,Vdim,Vsize,TRANS_NORMAL);
  n2R = vb_bvoyger_to_vox(n0R,Vdim,Vsize,TRANS_NORMAL);

  fprintf('%f[sec]\n',toc);
 case 'FreeSurfer'
  V2L = V0L; 
  V2R = V0R; 
  n2L = n0L;
  n2R = n0R; 
end

%
% --- Redeuce patchs
%
tic;
fprintf('--- Reduce cortical vertices ');

[F3L,V3L] = vb_reducepatch( F0L, V2L, brain_parm.reduce_ratio ); 
[F3R,V3R] = vb_reducepatch( F0R, V2R, brain_parm.reduce_ratio );  

fprintf('%f[sec]\n',toc);

%
% ---  Find original vertex point in BV-model corresponding to reduced model
%
tic;
fprintf('--- Find original point corresponding to reduced model ');

IndxL = vb_find_match_point( V2L, V3L, brain_parm.N_step );
IndxR = vb_find_match_point( V2R, V3R, brain_parm.N_step );

fprintf('%f[sec]\n',toc);

% ---  Normal vector obtained from original BV-model
n3L = n2L(IndxL,:);
n3R = n2R(IndxR,:);

%
% --- Right-hand SPM coordinate  [mm] 
%
% [Right-hand coordinate]
% X: Left(-191/2)   -> Right(191/2) 
% Y: Back(-256/2)   -> Front(256/2)
% Z: Bottom(-256/2) -> Top(256/2) 
%
switch filetype, 
 case 'BrainVoyager', 
  tic; 
  fprintf('--- Coordinate transformation (VOX to SPM-ANALYZE) ');
   V3L = vb_vox_to_spm_right(V3L,Vdim,Vsize,TRANS_COORDINATE);
   V3R = vb_vox_to_spm_right(V3R,Vdim,Vsize,TRANS_COORDINATE);

   n3L = vb_vox_to_spm_right(n3L,Vdim,Vsize,TRANS_NORMAL);
   n3R = vb_vox_to_spm_right(n3R,Vdim,Vsize,TRANS_NORMAL);
   
   fprintf('%f[sec]\n',toc);
 case 'FreeSurfer', 
end

% Vertex number of reduced model
NdipoleL = size(V3L,1);
NdipoleR = size(V3R,1);
Ndipole  = NdipoleL + NdipoleR;

F3R = F3R + NdipoleL;
F3  = [F3L ; F3R];
n3  = [n3L ; n3R]; 

NdipoleL0 = size(V0L,1);
clear V0L V0R V2L V2R F0L F0R n0L n0R n2L n2R Srf

%
% --- SPM cordinate in [m] , Normal vector is outward.
%
tic;
fprintf('--- Change coordinate to [m] ');
V  = [V3L ; V3R]./1000;

% Normalize normal vectors
nn = sqrt(sum(n3.^2 ,2)); 
ix = find(nn<eps);
if ~isempty(ix), 
	fprintf('!! There are abnormal normal vector \n'); 
	nn(ix)	 = 1; 
end
xx = -n3./repmat(nn ,[1 3]);


% triangle patch index for left/right brain
Npatch     = size(F3,1);
F.F3	   = F3;
F.F3R	   = F3R;
F.F3L	   = F3L;
F.NdipoleL = NdipoleL;

% BrainVoyager vertex index corresponding to reduced brain 'V'
BV_index.Left  = IndxL; 
BV_index.Right = IndxR+NdipoleL0;

% Dimensional info
Vinfo.Ndipole   = Ndipole;
Vinfo.NdipoleL  = NdipoleL;
Vinfo.Npatch    = Npatch;
Vinfo.NdipoleL0 = NdipoleL0;
Vinfo.Coord     = 'SPM_Right_m';

clear V3L V3R n3L n3R

fprintf('%f[sec]\n',toc);

