function    [overlap, ddmin,Indx] = vb_find_overlap(d)
% inverse distances between Vref and Vnew
% d = Dinv = vb_sparse_inv_distance(Vref,Vnew, Rmax);
%
% overlap.Noverlap    = number of duplicate point
% overlap.Ovlist(n)   = n-th duplicate point index of Vref
% overlap.Nmulti(n)   = number of multiple point (Vnew)
%                       corresponding to the same Vref
% overlap.Inew{n}     = index list of new vertex for Vref
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[Nref, Nnew] = size(d);

% Find nearest points from Vnew
[ddmin,Indx] = max(d,[],1);
ddmin = 1./ddmin;

% duplicate index of Vref
Iref = zeros(Nref,1);
Inew = cell(Nref,1);

for v=1:Nnew
    ref_index = Indx(v);
    % count same index
    Iref(ref_index) = Iref(ref_index)  + 1;
    Inew{ref_index} = [Inew{ref_index} , v];
end

overlap.Ovlist = find( Iref > 1);
overlap.Noverlap = length(overlap.Ovlist);
overlap.Nmulti = Iref(overlap.Ovlist);

overlap.Inew   = cell(overlap.Noverlap,1);

for n=1:overlap.Noverlap
    ref_index = overlap.Ovlist(n);
    overlap.Inew{n} = Inew{ref_index};
end

return

if overlap.Noverlap > 1, 
    fprintf('Noverlap = %d , Multiplicity = %d\n', ...
    overlap.Noverlap, sum(overlap.Nmulti)), 
end;

%return
