function	[nextIX , nextDD] = vb_find_neighbor_all(R, xxF, xxD, Vindx, Ndisp)
% Make neighbor index list within the radius R
%
% [syntax]
% [nextIX , nextDD] = vb_find_neighbor_all(R, xxF, xxD, Vindx, Ndisp)
%
% [input]
% xxF{i}  : <<cell>> Next-neighbor index that share the same triangle
% xxD{i}  : <<cell>> Distance between next-neighbor and the vertex-i
% Vindx   : <<vector>> Vertex index list for calculation
% Ndisp   : <<int>> display process each Ndisp point
%
% nextIX{i} : Neighbor index list for the vertex-i
% nextDD{i} : Distance from the vertex-i
%
% [history]
% Ver 1.0 written by M. Sato  2003-3-15
% 2004-03-09 Taku Yoshioka
%  Display progress bar
% 2010-05-26 Taku Yoshioka
%  Minor change (verbose level support)
% 2011-06-20 taku-y
%  [minor] Progress message was added. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

verbose_const = vb_define_verbose;
global vbmeg_inst;
if isempty(vbmeg_inst) | ~isfield(vbmeg_inst,'verbose_level'), 
  verbose_level = verbose_const.VERBOSE_LEVEL_NOTICE;
else
  verbose_level = vbmeg_inst.verbose_level;
end

tic;
vb_disp_nonl('Start neighbor search: ');

% Total Vertex point number
Nvertex  = size(xxF,1);	

if nargin<4, Vindx = 1:Nvertex; end;
if nargin<5, Ndisp = 100000; end;

nextIX	 = cell(Nvertex,1);
nextDD	 = cell(Nvertex,1);

% Number of target vertex for calculation
N = length(Vindx);		

% progress
prg     = 0;
prg_all = N;
h_prg   = vb_disp_waitbar(prg/prg_all,'Neighbor search');
vb_disp_nonl(sprintf('%3d %% processed',ceil(100*(prg/prg_all))));

% Make neighbor index list within the radius R
for n=1:N,
  ix = Vindx(n);	% Current vertex index
	
  [inext, nextdd] = vb_find_neighbor(R, ix, xxF, xxD );
  nextIX{ix} = inext;
  nextDD{ix} = nextdd;
  
  if mod(n,Ndisp)==0, 
    for ii=1:15; vb_disp_nonl(sprintf('\b')); end
    vb_disp_nonl(sprintf('%3d %% processed',ceil(100*(prg/prg_all))));
    vb_disp_waitbar(prg/prg_all,h_prg);
  end
  prg = prg+1;
end

vb_disp_nonl(sprintf(' %f[sec]\n',toc));
if ~isempty(h_prg) && ishandle(h_prg)
    close(h_prg);
end

return;
