function    [V, F, Iparent] = vb_divide_patch(V, F, xxT, Vindex)
% divide triangle by 4 :
% make new vertex at midpoint of triangle edge
%  [V, F, Iparent] = vb_divide_patch(V, F, xxT, Vindex)
% 
% xxT{n} : ĺ n  ܣֹ
% Iparent(n,1)   : vertex index for new vertex
% Iparent(n,2:3) : Parents vertex index for new vertex
%   Vmid = ( V(Iparent(:,2),:) + V(Iparent(:,3),:) )/2
%   V(Iparent(:,1),:) = Vmid./repmat( sqrt(sum(Vmid.^2,2)) ,1 , 3);

NV = size(V,1);
NF = size(F,1);

% target patch index for divide
DFindex = vb_cell_merge(xxT,Vindex);
DFindex = unique(DFindex );
Iremain = vb_setdiff2([1:NF],DFindex);

% patch without change
Fremain = F(Iremain, : );

% target patch for divide
divF = F(DFindex, : );
% target patch number
NDF = length(DFindex);

% Vertex coordinate for each Triangle 
v1 = V(divF(:,1),:);
v2 = V(divF(:,2),:);
v3 = V(divF(:,3),:);

% Midpoint for 3 edge
f1 = (v2+v3)/2;
f2 = (v3+v1)/2;
f3 = (v1+v2)/2;


% Midpoint vertex coordinate list
Vf = [f1;
      f2;
      f3];

% Edge index for midpoint
Jedge  = [ divF(:,2),divF(:,3); 
           divF(:,3),divF(:,1); 
           divF(:,1),divF(:,2)];

Jedge  = sort(Jedge,2);

% [B,I,J] = unique(A)        : B = A(I)   and  A = B(J)
% [B,I,J] = unique(A,'rows') : B = A(I,:) and  A = B(J,:))

% Extract unique edge index for midpoint
[Juniq, II, JJ ] = unique( Jedge, 'rows');

% Unique edge index
% Juniq = Jedge(II,:)  
% Jedge = Juniq(JJ,:) 

% Unique vertex coordinate for midpoint
Vnew = Vf(II,:);
Nnew = size(Vnew,1);

% Append midpoint after original V
V    = [ V ; Vnew]; 
Inew = (1:Nnew) + NV;

% Midpoint index from Vnew index
% Vnew = Vf(II,:);
% Vf   = Vnew(JJ,:);
Jnew = JJ + NV;

ix   = 1:NDF;

% Index of midpoint for [ divF(:,2),divF(:,3)];
J1   = Jnew(ix);
% Index of midpoint for [ divF(:,3),divF(:,1)];
J2   = Jnew(ix+NDF);
% Index of midpoint for [ divF(:,1),divF(:,2) ];
J3   = Jnew(ix+2*NDF);

% Patch index 
Fadd = [ divF(:,1), J2, J3; ...
         divF(:,2), J3, J1; ...
         divF(:,3), J1, J2; ...
         J1,J2,J3 ];

F = [Fremain; Fadd];


% Parent index for new midpoint
Iparent = [J1, divF(:,2), divF(:,3);
           J2, divF(:,3), divF(:,1);
           J3, divF(:,1), divF(:,2)];

% [B,I,J] = unique(A)  : B = A(I)   and  A = B(J)
[Iuniq , I, J]= unique(Iparent(:,1));

Iparent = Iparent(I,:);

return

% check Iparent
Nerr = Nnew - size(Iparent,1)

vmid = V(Iparent(:,2),:) + V(Iparent(:,3),:) ;
% Normalization
vmid = vmid./repmat( sqrt(sum(vmid.^2,2)) ,1 , 3);

err = sum((V(Iparent(:,1),:) - vmid).^2,2);

errsum = sum(err)

%   % Make 4 triangle patch for each triangle
%   vv1  = [ v1; v2; v3; f1];
%   vv2  = [ f2; f3; f1; f2];
%   vv3  = [ f3; f1; f2; f3];
%
%   v1   = vv1;
%   v2   = vv2;
%   v3   = vv3;
%   
