function   xxave = vb_cortex_normal_average(brainfile,areafile,area_key,coord_type)
% average normal direction in the neighbor of vertex
%  xxave = vb_cortex_normal_average(brainfile,areafile,areakey,coord_type)
% --- Input
% brainfile
% areafile
% areakey
% coord_type : = 'subj' : subject cortex normal.  [default]
%              = 'std'  : standard cortex normal.
%
% In the brainfile, 'normal_stat' should be exist:
%   normal_stat.neighbor_org : original brain neighbor index list
%   normal_stat.normal_org   : original brain normal vector
% --- Output
% xxave : average normal vector  (NP x 3)
%
% M. Sato  2006-7-23
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('coord_type', 'var')
    coord_type = 'subj';
end
normal_stat = vb_load_normal_statics(brainfile, coord_type);

%
% --- Average normal vector
%
fprintf('--- Average normal vector\n')
xxave = vb_calc_normal_average(normal_stat.neighbor_org, normal_stat.normal_org);

%
% select area
%
if exist('areafile','var') & exist('area_key','var') ...
     & ~isempty(areafile) & ~isempty(area_key),
	Area = vb_get_area([areafile], area_key);
	ix   = Area.Iextract;
	xxave = xxave(ix,:);
end
