function	[Vext,FL,FR] = vb_calc_subj_patch(IL,IR,VLs,FLs,VRs,FRs)
% Simple case: Find nearest point from 'VL' to 'VLs'
% [IL, ddL,VLs,FLs] = vb_find_no_overlap_divide(VLs, VL, FLs);

% Reference: reduced vertex 'VLs' and patch 'FLs'
% Target: brain model vertex 'VL' correspond to 'VLs(IL,:)'
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% number of vertex in 'VL'
NL = length(IL);
NR = length(IR);
% number of all vertex in 'VLs'
NLall = size(VLs, 1);
NRall = size(VRs, 1);
% remainning vertex other than 'IL'
IL_extra = vb_setdiff2([1:NLall],IL);
IR_extra = vb_setdiff2([1:NRall],IR);

NL_extra = length(IL_extra);
NR_extra = length(IR_extra);

% reorder of extra vertex
Vext = [VLs(IL_extra,:); VRs(IR_extra,:)]/1000;
Nall = size(Vext,1) + NL + NR;

if Nall ~= (NLall + NRall),
	error('dimension error')
end

% transform in 'FLs'
% IL -> 1:NL
% IL_extra -> (1:NL_extra) + (NL + NR);
ItransL = zeros(NLall,1);
ItransR = zeros(NRall,1);

ItransL(IL) = 1:NL;
ItransL(IL_extra) = (1:NL_extra) + (NL + NR);

ItransR(IR) = (1:NR) + NL;
ItransR(IR_extra) = (1:NR_extra) + (NL + NR + NL_extra);

FL = ItransL(FLs);
FR = ItransR(FRs);

ix = find( FL(:,1).*FL(:,2).*FL(:,3) > 0);
FL = FL(ix,:);

ix = find( FR(:,1).*FR(:,2).*FR(:,3) > 0);
FR = FR(ix,:);

