function xxA = vb_asign_ext_area(xxA_all, base_index, ext_index, ext_table)
%  asign external vertex area to base vertex area according to distance
%  xxA = vb_asign_ext_area(xxA_all, base_index, ext_index, ext_table);
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Nbase = length(base_index);
Next  = length(ext_index);

xxA = xxA_all(base_index);

for i=1:Next
    ix = ext_index(i);
    jx_list = ext_table{i};
    
    Nj = length(jx_list);
    
    for j = 1:Nj
        jx = jx_list(j);
        xxA(jx) = xxA(jx) + xxA_all(ix)/Nj;
    end
end;
