function [varargout] = vbmeg(command, arg1)
% This function is an environmental configuration file of VBMEG. 
% Usage:
%  vbmeg('command', arg1)
% [command]
%   'set_path'   : (default)set program directories to MATLAB path.
%                : Path is added found by which('vbmeg') command.
%   'version'    : display current vbmeg version
%   'set_global' : only set global constant values
%   'save_version' : set saving version
%                  : This command requires 'arg1'.
%                  : The 'arg1' is given the save command as a version option.
%                  :  e.g. '-v6' '-v7.3' ['']
%   'vb_rc_file' : return vbmeg resource filename.
%
% [history]
%   200X-XX-XX (Hayashi) initial version
%   2008-01-25 (Sako) changed '-version' to 'version' and added 'set_global'
%   2009-07-06 (Sako) added 'save_version' command
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('command', 'var')
    command = 'set_path';
end

global vbmeg_inst
global vbmeg_saving_version
global reduce_algorithm;

reduce_algorithm = 'CGAL'; % reduce algorythm used in vb_reducepatch
                           % = 'MATLAB' : MATLAB reducepatch is used.
                           % = 'CGAL'   : CGAL is used.

switch(command)
case 'set_path'
    prog_file = which('vbmeg.m');
    ix = findstr(prog_file,filesep);
    prog_dir = prog_file(1:ix(end));
    disp('--- Find VBMEG program directory'); 
    fprintf('VBMEG program directory: %s\n',prog_dir);

    %vbmeg_home_dir = vb_set_prog_dir(prog_dir);
    vbmeg_home_dir = prog_dir;
    addpath(vbmeg_home_dir);
    addpath(genpath(fullfile(vbmeg_home_dir, 'external')));
    addpath(genpath(fullfile(vbmeg_home_dir, 'functions')));
    addpath(genpath(fullfile(vbmeg_home_dir, 'standard_brain')));

%     global vbmeg_inst

    disp('--- Set program directories to MATLAB path');
    vbmeg_inst.const = vb_define_set(vbmeg_home_dir);
    
    verbose_const = vb_define_verbose;
    vbmeg_inst.verbose_level = verbose_const.VERBOSE_LEVEL_NOTICE;

    disp('--- Create global variable ''vbmeg_inst''')

  case 'version'
    [major, minor, alpha_beta, rev] = vb_version;
    ver_str = sprintf('%.1f-%d.%c.%d', major, minor, alpha_beta, rev);
    % disp(ver_str);
    varargout{1} = ver_str; % return version string
    
  case 'set_global'
    vbmeg_inst.const = vb_define_set;
    disp('--- Create global variable ''vbmeg_inst''')
    
  case 'save_version'
    if ~exist('arg1', 'var') || isempty(arg1)
      vbmeg_saving_version = '';
      disp('VBMEG Save format reset to : system setting.');
    elseif (strcmpi(arg1, '-v6') || strcmpi(arg1, '-v7') || strcmpi(arg1, '-v7.3') || ...
       (vb_matlab_version('>=', '9.2') && strcmpi(arg1, '-v7.3 -nocompression')) )
      fprintf('VBMEG Save format set to : %s\n', arg1);
      vbmeg_saving_version = arg1;
    else
        if vb_matlab_version('>=', '9.2')
            error('save_version : ''-v6'' or ''-v7'' or ''-v7.3'', ''-v7.3 -nocompression''');
        else
            error('save_version : ''-v6'' or ''-v7'' or ''-v7.3''');
        end
    end
  case 'vb_rc_file'
    varargout{1} = fullfile(vb_get_file_parts(which('vbmeg.m')), 'vbmegrc');
  otherwise
    error('Unknown command: %s', command);  
        
end

% for CGAL module
iso2mesh_dir = fileparts(which('cgalsurf'));
if ~ispc
    iso2mesh_bin = fullfile(iso2mesh_dir, '*.*');
    cmd = ['chmod 755 ' iso2mesh_bin];
    system(cmd);
end
