function	[pick,Qpick,Weight,ch_meg] = get_pos_neuromag(ch_info)
% get neuromag sensor position in head coordinate
%  [pick,Qpick,Weight] = get_pos_neuromag(ch_info)
%
%    ch_info     @ channel information is including transform matrix
%             .Nch      [double]
%                 : The number of channels.
%             .channel_ix   [Nch x 1 double]
%                 : MEG channel name list.
%             .sensort_type [Nch x 1 double]
%                 : sensor type list
%             .coil_type    {Nch x 1 cell}
%                 : coil type string list
%                   ex. coil_type{1} = 'VV_PLANAR_T1'
%             .trans_coil2head   : {Nch x 1}
%                 : transformation matrix (COIL  ==> HEAD)
%                   trans_coil2head{n} = [4x4 double]
%             .trans_coil2device : {Nch x 1}
%                 : transformation matrix list (COIL  ==> DEVICE)
%                   trans_coil2device{n} = [4x4 double]
%             .trans_device2head : [4 x 4 double]
%                 : transformation matrix (DEVICE  ==> HEAD)
%
%  [rHead 1] = [rCoil 1] * ch_info.trans_coil2head{n}'
%
% Masa-aki Sato 2009-4-13
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Nch = ch_info.Nch;

% ch_info.coil_type : 
% ch_info.sensor_type : 0 for magnetometers, 1 for planar gradiometers
% ch_info.channel_name : 'MEG xxxx'
%sensor_type  = ch_info.sensor_type;
%channel_name = ch_info.channel_name;

ch_meg = zeros(Nch,1);

% Coil position & direction
pick  = [];
Qpick = [];

% Coil -> Channel matrix index
n_coil	 = [];
n_channl = [];
n_val	 = [];

Ncoil = 0;
Nchan = 0;

% Head coordinate
for n=1:Nch
	% Transformation matrix from coil -> head
	U = ch_info.trans_coil2head{n}';
	
	% Get coil position & direction
	% fixed coil position is defined for coil_type in Coil coordinate
	if iscell(ch_info.coil_type)
		[pick1, Qpick1, w] = sensor_pos_neuromag(ch_info.coil_type{n}, U);
	else
		[pick1, Qpick1, w] = sensor_pos_neuromag(ch_info.coil_type(n), U);
	end
	
	Npick  = size(pick1,1);
	
	if Npick > 0,
		% MEG channel
		ch_meg(n) = 1;
		
		% Coil index
		ix = (1:Npick) + Ncoil;
		
		% Coil position & direction
		pick  = [pick ; pick1];
		Qpick = [Qpick; Qpick1];
		
		% Coil -> Channel matrix index
		% Channel index
		Nchan = Nchan + 1;
		n_channl = [n_channl;  repmat(Nchan, [Npick, 1])];

		% Coil index
		n_coil = [n_coil; ix(:)];
		n_val  = [n_val ; w(:) ];
		Ncoil = Ncoil + Npick;
	end
end

Weight = sparse(n_channl, n_coil, n_val, Nchan, Ncoil, Ncoil);

%ch_id  = find(ch_meg > 0);
