function [name, point] = vb_mps_pointlist_get_point(obj, index)
% get point from mps_pointlist object.
% [USAGE]
%    [name, point] = vb_mps_pointlist_get_point(<obj>, <index>);
% [IN]
%    obj : mps_pointlist object
% [OUT]
%    index : Item index
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('obj', 'var'), error('obj is need parameter'); end
if ~exist('index', 'var') || isempty(index)
    error('index is need parameter.');
end
    
name  = obj.name_list{index};
point = obj.point_list{index};
