function [obj] = vb_mps_pointlist_delete_point(obj, name)
% delete point from mps_pointlist object.
% note: delete key is name(char string).
% [USAGE]
%    [obj] = vb_mps_pointlist_delete_point(<obj>, <name>);
% [IN]
%     obj : mps_pointlist object
%    name : point name
% [OUT]
%    obj : mps_pointlist object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('obj', 'var'), error('obj is need parameter'); end
if ~exist('name', 'var'), error('name is need parameter'); end

%
%  --- Search by name and remove point.
%
remove_ix = strmatch(name, obj.name_list, 'exact');
if ~isempty(remove_ix)
    obj.name_list(remove_ix) = [];
    obj.point_list(remove_ix) = [];
end

