function [obj] = vb_surf_element_new(name, coord_type, V, F, xx)
% constructor of surf_element object
% [USAGE]
%    [obj] = vb_surf_element_new(<name>, <coord_type>, <V>, <F>, <xx>);
% [IN]
%          name : <<char array>> name of surf_element
%    coord_type : coordinate space type
%             V : Vertex
%             F : Face
%            xx : normal vector
% [OUT]
%    obj : surf_element object
% [See]
%    relative function : vb_display_element_new
% Author: rhayashi
% Created: 2007-07-17
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('name', 'var'), error('name is a required parameter.'); end
if ~exist('coord_type', 'var')
    error('coord_type is a required parameter.');
end
if ~exist('V', 'var'), error('V is a required parameter.'); end
if ~exist('F', 'var'), error('F is a required parameter.'); end
if ~exist('xx', 'var'), error('xx is a required parameter.'); end

%
% --- Main Procedure
%

% Inherit display_element class
obj = vb_display_element_new(name, coord_type);

% surf_element members
obj.class_name = 'surf_element';
obj.V = V;
obj.F = F;
obj.xx = xx;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
