function Jpred = lcd_forward_prediction(conMAR,J,Nstep)
% Repeated N-step prediction by MAR dynamics 
%
% [Input]
% conMAR : concatenated MAR matrix [Nv Nv*Dmax]
% J :  current timeseries [Nv Nt]   
% Nstep  : prediction time step   (1*1) 
%
% [Output]
% Jpred  : predicted waveforms. Jpred(:,t) is the N-step prediction of 
%         J(:,t) (i.e. prediction using J(:,t-Nstep) ) 
%
% Nv : number of vertex
% Nt : number of time points
%
% 2016/01/28 O.Yamashita


[Nv,Nvl] = size(conMAR);
Dmax = Nvl/Nv;
Nt = size(J,2);

xx0 = zeros(Nv, Nstep+Dmax);
xx = [xx0 J];

% forward prediction
Jpred = zeros(Nv,Nt);  % Predicted J

for tt = Nstep+Dmax+1 : Nt+Nstep+Dmax
    %fprintf('process time = %03d ...\n',tt-Nstep-Dmax);
    x0 = xx(:,tt-Nstep:-1:tt-Nstep-Dmax+1);    % Nv*Dmax
    for st = 1 : Nstep
        xtmp = conMAR*x0(:);
        x0 = [xtmp x0(:,1:Dmax-1)];
    end
    Jpred(:,tt-Nstep-Dmax) = x0(:,1);   
end

