function	h = plot_pair_ch(parm, facefile, p)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% get_shortest_path from source to detector along head
[Xpath, Npath] = get_shortest_path(parm, facefile);

%
% --- Plot surface 
%
% Face surface
face = load(facefile);
V = face.Vspm;
F = face.F;

h = figure;
vb_plot_surf(V,F);
camlight headlight;
view(p.angle);
axis equal

hold on;

% source & detector channel pos
Npair = length(Npath);

src_pos = zeros(Npair,3);
det_pos = zeros(Npair,3);
ch_pos  = zeros(Npair,3);

for k=1:Npair
	Vpath = Xpath{k};
	NP = Npath(k);
	
	src_pos(k,:) = Vpath(1,:);
	det_pos(k,:) = Vpath(end,:);
	% channel posisin: mid point
    N1 = max(fix(NP/2),1);
	ch_pos(k,:)  = Vpath(N1,:);
end

% Plot source & detector channel
plot3(src_pos(:,1), src_pos(:,2), src_pos(:,3), p.Msend,'MarkerSize',p.Msize);
plot3(det_pos(:,1), det_pos(:,2), det_pos(:,3), p.Mrecv,'MarkerSize',p.Msize);

%
% ----- Plot shortest path from source to detector
%

for k=1:Npair
	% get_shortest_path from source to detector along head
	Vpath = Xpath{k};
	NP = Npath(k);
    N1 = max(fix(NP/2),1);
    ix1 = 1:N1;
    ix2 = N1:NP;
    
    plot3(Vpath(ix1,1), Vpath(ix1,2), Vpath(ix1,3), p.Lsend); % source 
    plot3(Vpath(ix2,1), Vpath(ix2,2), Vpath(ix2,3), p.Lrecv); % detector
end

