function	plot_cylinder_anime(p, h, Q, id)
%  p : Plot parameter
%  Q{n} : active history buffer for n-th cylinder
% --- pair of vetex coordinate for connections
% id.I_from : start vertex index
% id.I_to   : end vertex index
%
% 2014-11-10 Masa-aki Sato
% 2017-12-12 Yusuke Takeda Modified details
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global cancel;

%--- Load current
[Z, I] = movie_current_load(id, p);

if isfield(p,'abs_mode') && p.abs_mode==1
    Z = abs(Z);
end

if isfield(p,'max_norm') && p.max_norm==1
    Zmax = max(abs(Z),[],2);
    Z = vb_repmultiply(Z, 1./Zmax);
else
    Zmax = max(abs(Z(:)));
    Z = Z./Zmax;
end

Zmax = max(Z(:));
Zmin = min(Z(:));
caxis([Zmin Zmax*p.show_max]);

%%--- load MAR weight
if isfield(p,'wmulti') && p.wmulti==1
    load(p.conn_file, 'mar');
    %--- id.Index : selected connection index
    mar = mar(id.Index);
    Z = vb_repmultiply(Z,mar);
end

[ND, T]= size(Z);

angle = p.angle;
alpha_val  = p.alpha(1);
alpha_area = p.alpha_area(1);

view(angle);
alpha(h.hf, alpha_val);

%
if p.video==1
    writerObj = video_prepare(p.video_dir);
end

%return
%----- change transparency & zoom
Nstep = ceil(abs(p.alpha(2)-p.alpha(1))/p.alpha(3));
zoom_factor = nthroot(p.zoom_factor, Nstep);
k     = 0;
while alpha_val > p.alpha(2)
    if p.video==1
        writeVideo(writerObj, getframe(1));
    end
    alpha_val  = alpha_val - p.alpha(3);
    alpha(h.hf, alpha_val);
    
    if p.roi==1
        alpha_area = alpha_area - p.alpha_area(3);
        alpha_area = max(alpha_area, p.alpha_area(2));
        
        alpha(h.h_area, alpha_area);
    end
    if p.face_on
        alpha(h.h_face, p.alpha_face*(1-(k/Nstep)));
        camzoom(zoom_factor);
        k = k+1;
    end
    pause(p.pause1)
end
if p.face_on
    alpha(h.h_face, 0);
end

set(h.hf , 'FaceColor',p.faceclr0)

set(h.hf, 'SpecularStrength', 0, 'AmbientStrength', 1.0);
if p.roi==1
    set(h.h_area, 'SpecularStrength', 0, 'AmbientStrength', 1.0);
end
%----- rotate axis
for n=1:p.Ntime
    if p.video==1
        writeVideo(writerObj, getframe(1));
    end
    
    angle = angle + p.dang;
    view(angle);
    
    pause(p.pause1)
    %	drawnow
    
    if cancel == true
        break;
    end
end

if p.pmove==0, return; end;

%set(hf,	'Visible', 'off');
if p.roi==1
    alpha(h.h_area, p.alpha_area(2));
end
t = 0; ts = 0;  r0 = 0.01;
%----- plot signal transition
while ts <= T
    [az, el] = view;
    %    title(h.ax_time, sprintf('%.1f[ms](%.1f, %.1f)', ts, az, el), 'Color', 'w', 'FontSize', 20);
    title(h.ax_time, sprintf('%.1f[ms]', p.Timefrom + ts*1000/p.Tfreq), 'Color', 'w', 'FontSize', 20);
    
    % rotate figure
    if ts > p.Tstay
        if ~isempty(p.Tstop) && ts > p.Tstop
            % stop change angle
        else
            % change angle
            angle = angle + p.dang;
        end
    end
    view(angle);
    
    t = t + 1;
    ts = ts + 1;
    
    % time index for Jpred
    tc = mod(t-1 , T) + 1;
    
    %--- Loop for each cylindrical line
    for m=1:ND
        n = I(m);
        
        % set values for n-th cylinder
        [J, Q{n}, tp] = set_cylinder_val(Q{n}, Z(m,tc), t, p.dN);
        
        % update patch values
        set(h.hp(n), 'FaceVertexCData',J);
        
        % update start-end vertex
        if p.vertex_show > 0
            val1 = Q{n}(tp(1));
            val2 = Q{n}(tp(end));
            col1 = get_col_from_val(val1,[Zmin Zmax],p.cmap2);
            col2 = get_col_from_val(val2,[Zmin Zmax],p.cmap2);
            
            if val1 >= p.th_show*Zmax,
                switch	p.vertex_show
                    case	1
                        rd1  = p.Msize*(val1-Zmin)/(Zmax-Zmin);
                    case	2
                        rd1  = p.Msize;
                end
            else
                rd1  = r0;
            end
            
            if val2 >= p.th_show*Zmax,
                switch	p.vertex_show
                    case	1
                        rd2  = p.Msize*(val2-Zmin)/(Zmax-Zmin);
                    case	2
                        rd2  = p.Msize;
                end
            else
                rd2  = r0;
            end
            
            set(h.hp1(n), 'MarkerFaceColor',col1,...
                'MarkerEdgeColor',col1,...
                'MarkerSize',rd1);
            set(h.hp2(n), 'MarkerFaceColor',col2,...
                'MarkerEdgeColor',col2,...
                'MarkerSize',rd2);
            
        end
    end
    
    if p.video==0
        pause(p.pause2)
    end
    %	drawnow
    
    if cancel == true
        break;
    end
    
    if p.video==1
        writeVideo(writerObj, getframe(1));
    end
end
%------------------------- END ------------------
if p.video==0, return; end;

close(writerObj);
return
