function corrected_bvec_file = ecc_bvecs(ecclog,bvecsfile)
% ecc_bvecs(ecclog,bvecsfile)
%
% S.Jbabdi 03/2009
% M.Fukushima 2012/06/10
% R.Hayashi   2013/11/20 corrected file is put to tempname.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% read bvecs file
bvecs = load(bvecsfile);
if(size(bvecs,2)==3 && size(bvecs,1)>3)
    bvecs = bvecs';
end
ecclog_tmp_file = tempname;

% read ecc-log file
[stat,ret] = unix(['cat ' ecclog ' | grep Final -A 4 | sed s/"Final result:"//g | sed s/--//g > ' ecclog_tmp_file]);
if stat ~= 0
    error(['error occured', ret]);
end
mat = load(ecclog_tmp_file);

% rotate bvecs
rotbvecs = zeros(size(bvecs));
for i = 1:size(bvecs,2)
    M = mat((i-1)*4+1:i*4,:);
    M = M(1:3,1:3);
    
    % extract rotation matrix
    [u,s,v] = svd(M*M');
    R = inv(u*sqrt(s)*v')*M;
    
    rotbvecs(:,i) = R*bvecs(:,i);
end

% save([bvecsfile '_rot'],'rotbvecs','-ascii','-double');
corrected_bvec_file = tempname;
saveascii(rotbvecs,corrected_bvec_file,14);


