function h = dmri_plot_dmri_connections_matrix(dmri_file, brain_file, area_file)
% Plot dmri connection between regions.
% [Usage]
%    h = dmri_plot_dmri_connections_matrix(dmri_file, brain_file, area_file);
%
% [Input]
%    dmrifile  : connectivity matrix obtained from DMRI processor
%    brainfile : brainfile of VBMEG
%    areafile  : areafile of VBMEG. coarse region parcellation such as AAL and
%                brodmann. AAL is recommended.
%
% [Output]
%    h : figure handle
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin < 3
    error('Please check usage.');
end

if exist(dmri_file, 'file') ~= 2
    error('dmri_file not found : %s', dmri_file);
end
if exist(brain_file, 'file') ~= 2
    error('brain_file not found : %s', brain_file);
end
if exist(area_file, 'file') ~= 2
    error('area_file not found : %s', area_file);
end

%
% --- Main Procedure
%

%  CC : region connectivity matrix (number of connections average over region vertices)
%  DD : region distance matrix in unit meter  (distance average over region vertices). 
[CC,DD,xyz0,Keys0]=dmri_connections_regions_calc(dmri_file, brain_file, area_file);

h = figure;
set(h, 'Name', dmri_file, 'NumberTitle', 'off');

% plot1
subplot(2,1,1);
imagesc(CC, [0 1]);
colorbar;
axis square;
title('Connectivity matrix');

% plot2
subplot(2,1,2);
imagesc(DD, [0 0.1]);
colorbar;
axis square;
title('Distance matrix');
