function dmri_mrview(struct_file)
% MRTrix viewer 'mrview' requires .nii file.
% This function launches 'mrview' with file extension .nii or .nii.gz file.
%
% [Usage]
%    dmri_mrview(struct_file);
%
% [Input]
%    struct_file : niftigz or nifti format of MR image.
%
% [Output]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin ~= 1
    error('Please check input argument.');
end
if exist(struct_file, 'file') ~= 2
    error('Specified file not found.');
end

%
% --- Main Procedure
%
nii_created = false;
if strcmpi(struct_file(end-6:end), '.nii.gz')
    unzip_struct_file = strrep(struct_file, '.nii.gz', '.nii');
    if exist(unzip_struct_file, 'file') ~= 2
        nii_created = true;
        system(['gunzip -c -d ', struct_file ' > ' unzip_struct_file]);
    end
    struct_file = unzip_struct_file;
end
% Launch viewer
dmri_system(['mrview ', struct_file, ' -debug'], '-echo');

if nii_created
    delete(unzip_struct_file);
end

