function dmri_merge_parcels_wm(parcel_all_file, wm_file, parcel_wm_file)
% Merge parcel_all.nii.gz and wm.nii.gz and binarize it.
% [Usage]
%    dmri_merge_parcel_wm(parcel_all_file, wm_file, parcel_wm_file);
% [Input]
%    parcel_all_file : parcel_all.nii.gz file
%    wm_file         : wm.nii.gz
%    parcel_wm_file  : merged and binarized file.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

tmpfile = [tempname, '.nii.gz'];
dmri_add_images(parcel_all_file, wm_file, tmpfile);

cmd = ['fslmaths', ...
       ' ', tmpfile, ...
       ' -thr 0 -bin ', parcel_wm_file];
dmri_system(cmd);

disp(sprintf('mask file created: %s', parcel_wm_file));
