function dmri_process_FA_parcel_volume_files_create(p)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

disp(mfilename);

%
% --- Convert parcels to label
%
parcel_file    = fullfile(p.output_dir, p.vbmeg_dirname, p.parcels_file);
fs_info_file   = fullfile(p.output_dir, p.vbmeg_dirname, 'fs_info/fs_info.mat');
label_dir      = fullfile(p.output_dir, p.parcels_dirname, 'parcels_label');

dmri_parcel_to_label_file(parcel_file, fs_info_file, label_dir);


%
% --- Convert label to FA volume.
%
if isfield(p, 'ref_fs_dir') && ~isempty(p.ref_fs_dir)
    fs_dir = p.ref_fs_dir;
else
    fs_dir = fullfile(p.output_dir, p.fs_dirname, p.fs_sbj_name);
end
ref_struct_file  = fullfile(p.output_dir, p.t1_dirname,  [p.t1_brain_basename, '_brain.nii.gz']);
ref_FA_file      = fullfile(p.output_dir, p.dwi_dirname, [p.FA_basename '.nii.gz']);
trans_info_dir   = fullfile(p.output_dir, p.transform_info_dirname);
output_dir       = fullfile(p.output_dir, p.parcels_dirname);
Nprocess         = 10; % The number of Linux processes to make volume files.

dmri_label_file_to_FA_volume(label_dir, ...
                             fs_dir,    ...
                             ref_struct_file, ref_FA_file, ...
                             trans_info_dir, ...
                             output_dir, ...
                             Nprocess);

%
% --- Check parcellation result
%
dmri_parcel_view(fs_dir, output_dir, 'l'); % 'l' : left hemisphere
                                          % 'r' : right hemisphere
