
% Create Skull stripped brain and brain mask
data_dir = '/home/cbi-data4/rhayashi/DWI/test_dti_job_dti_preprocess';
dti_4d_image  = [data_dir, '/dti4d_ecc.nii.gz'];

threshold = 0.18;
brain_image_extract(dti_4d_image, threshold);

% !! Quality Check !!
% Is extracted skull stripped brain Okay?(Check the result.)
command = ['fslview ' [data_dir, '/dti4d_ecc_brain.nii.gz'],' ', [data_dir, '/dti4d_ecc.nii.gz']];
dmri_system(command);

% Create FA image for coregistration
% between (freesurfer/T1/FA) space
% (The FA image will be created here is less quality because 
%  brain_mask_file is made by dti image. We creates high quality FA image 
%  later using T1 brain mask.)
bvec_file       = [data_dir, '/dti4d_ecc_bvec'];
bval_file       = [data_dir, '/dti4d_ecc_bval'];
brain_mask_file = [data_dir, '/dti4d_ecc_brain_mask.nii.gz'];
output_dir      = data_dir;
output_name     = 'rough_FA';

dmri_FA_image_create(dti_4d_image, ...
                     bval_file, bvec_file, ...
                     brain_mask_file, ...
                     output_dir, ...
                     output_name);
    % will put files into the same directory.
    %    output_dir/output_name.nii.gz

