function	[label, key] = vb_read_atlas_label(atlas_text)
% Read atlas text file and extract area keys.
%   [label, key] = vb_read_atlas_label(atlas_text)
% --- Input
% atlas_text : atlas text file name
% --- Output
% label(n) : label value for n-th area
% key{n}   : label name for n-th area
%
%% 2006/11/14 M.Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

fid = fopen(atlas_text);

if fid == -1, error(sprintf('[%s] can not be opened',atlas_text)); end

Nlabel = 0;

% Get label name and value

while 1
    str = fgets(fid);
    if str == -1  %% if end of the file, go out from loop
        break
    end
 
    split  = explode(str,9); % 9 is ascii code of TAB
    Nsplit = length(split);
    
    if Nsplit > 1
    	Nlabel = Nlabel + 1;
        label(Nlabel) = str2num(split{1}); % area label
        key{Nlabel}   = deblank(split{2}); % area key
        fprintf('Label : %d, Key : %s\n', label(Nlabel),key{Nlabel});
    end
end

fclose(fid);
