function	vb_plot_atlas(brainfile,atlasfile,atlas_id,mode)
% Plot atlas region in brain
%  vb_plot_atlas(brainfile,atlasfile,atlas_id)
%  vb_plot_atlas(brainfile,atlasfile,atlas_id,mode)
% --- Input
% brainfile
% atlasfile
% atlas_id
% --- Optional Input
% mode = 0 : Plot Inflate-model
%      = 1 : Plot real brain in 3D-space
%
% 2006-11-12 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% ---------- Plot atlas region in brain
%

if ~exist('mode','var'), mode=0; end

switch	mode
case	0
	[V, F] = vb_load_cortex(brainfile,'Inflate');
case	1
	[V, F] = vb_load_cortex(brainfile);
end

Act    = vb_get_act(atlasfile,atlas_id);
Vlabel = Act.xxP  ;
label  = Act.label;

fclr = [0.8 0.7 0.6];
eclr = 'none';

angl = [ 35  20; -35  20];
%angl = [ -90 -20; 90 -20];

NL	 = F.NdipoleL;
FL	 = F.F3L;
FR	 = F.F3R;
NV   = size(V,1);

Lmax = max(V(1:NL,:));
Lmin = min(V(1:NL,:));
Rmax = max(V((NL+1):end,:));
Rmin = min(V((NL+1):end,:));

NX=2;
NY=1;

figure;

Maxlabel = length(label);

cmap = vb_get_class_color(Maxlabel);
%
% ---- Plot labeled region in Left brain
%
subplot(NY,NX,1);

ix = find( Vlabel == 0 );
Fx = vb_patch_select(ix,FL,NV);
vb_plot_surf(V,Fx,'w');
hold on;

ncolor = 0;

for n=1:Maxlabel
	ix = find( Vlabel == label(n) );
	if ~isempty(ix)
		ncolor = ncolor + 1;
		Fx = vb_patch_select2(ix,FL,NV);
		vb_plot_surf(V,Fx,cmap(ncolor,:));
	end
end

view(angl(1,:));
title('Anatomic region in left brain')

xlim([Lmin(1) Lmax(1)]);
ylim([Lmin(2) Lmax(2)]);
zlim([Lmin(3) Lmax(3)]);

%
% ---- Plot labeled region in Right brain
%
subplot(NY,NX,2);

ix = find( Vlabel == 0 );
Fx = vb_patch_select(ix,FR,NV);
vb_plot_surf(V,Fx,'w');
hold on;

ncolor = 0;

for n=1:Maxlabel
	ix = find( Vlabel == label(n) );
	if ~isempty(ix)
		ncolor = ncolor + 1;
		Fx = vb_patch_select2(ix,FR,NV);
		vb_plot_surf(V,Fx,cmap(ncolor,:));
	end
end

view(angl(2,:));
title('Anatomic region in right brain')

xlim([Rmin(1) Rmax(1)]);
ylim([Rmin(2) Rmax(2)]);
zlim([Rmin(3) Rmax(3)]);


return
