function	[ixlist,Nlist] = vb_get_atlas_index(arealist,Act)
% Get area index corresponding to atlas map in the given area
%
% [ixlist,Nlist] = vb_get_atlas_index(arealist,Act)
% --- Input
% arealist{n}  : cell array of area name
% Act : atlas structure
% Act.xxP        :label value for each vertex [Nvertex x 1]
% Act.label      :label value;
% Act.label_name :label_name corresponding to 'label'
% --- Output
% ixlist{n} : set of area index corresponding to atlas region
% Nlist(n)  : # of points in ixlist{n}
%
%% 2006/11/14 M.Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

xxP        = Act.xxP        ; % label value for each vertex [Nvertex x 1]
label      = Act.label      ; % label value;
label_name = Act.label_name ; % label_name corresponding to 'label'

Narea  = length(arealist);
ixlist = cell(1,Narea);
Nlist  = zeros(Narea,1);

for n=1:Narea
    % vertex index in n-th area
    I = strmatch(arealist{n},label_name,'exact');
    if isempty(I), continue; end;
    
    ix = find( xxP == label(I) );
    ixlist{n} = ix; 
    
    Nlist(n)  = length(ix);
end
