function vb_correct_atlas_label_repeat(Para)
% Correct holes and islands in atlas label
%   vb_correct_atlas_label_repeat(atlasfile,brainfile,Para)
% Para.atlasfile
% Para.atlasout
% Para.brainfile
%
% Para.Rlabel : max radius for morphology  [mm]
% Para.rate : number less than rate*(# of largest region) is deleted
% Para.Nmin : number less than Nmin is deleted
% Para.Ncorrect : number of repeat
% Para.Nfinal : target number of Unlabeled points
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% number of iteration for atlas correction
Ncorrect_min = 5;

if isfield(Para,'Ncorrect')
	Ncorrect  = Para.Ncorrect;
else
	Ncorrect  = 15;
end
if isfield(Para,'Nfinal')
	Nfinal  = Para.Nfinal;
else
	Nfinal  = 0;
end

load(Para.atlasfile);

Atlas = Act{1};

Non_label = sum( Atlas.xxP == 0 );
if Non_label==0, return; end;

%
% --- Correct atlas by removing disconnected vertex and filling holes
%
for n=1:Ncorrect
	fprintf('Iteration = %d\n',n)
	
	[Atlas,result] = vb_correct_atlas_label(Atlas, Para.brainfile, Para);
	
	if result == 0, break; end;
	
	Non_label = sum( Atlas.xxP == 0 );
	if Non_label <= Nfinal,  break; end;
	if n > Ncorrect_min && Non_old <= Non_label
		break;
	end
	Non_old = Non_label;
end

if isfield(Para,'atlasout')
	vb_add_act(Para.atlasout, Atlas, [],false);
end
