function [XYZmni , XYZtal, dd, IMGinfo, pXYZmni] = vb_calc_mni_coord(parm)
% Transform coordinate of vertex points on an individual brain to those on the MNI starndard brain. 
% 
% MNI coordinate as well as Talairach coordinate corresponding to 'V' are
% returned. This routine requires SPM spatial normalization file.
% 
% -- Usage
% [XYZmni , XYZtal, dd, IMGinfo] = vb_calc_mni_coord(parm)
%
% -- Input (Fields in 'parm' struct)
% brainfile     : Subject brain file
% mask_file     : Mask image file 
% snfile        : Created by SPM normalization (Personal-> MNI-template). 
%                 The normalize transformation is contained.
% 
% -- Output
% XYZmni  :  MNI coordinate  (unit:m)       [Nveretex * 3]
% XYZtal  :  Talairach coordinate (unit:m)  [Nveretex * 3]
% dd      :  minimum error distance between 'V' and points on the MNI standard brain
% IMGinfo :
%
% -- Function required  
%  spm_dctmtx   :
%  vb_unsn         : back transformation   (by Gohda-san)
%
% --- NOTE 1 ----
% When using the normalize transformation created by 'spm99', it is observed that  
% x (Left-Right) coordinates are a little shifted after back-transformation in this routine.
% It is highly recommended to recalculate the normalize transformation by
% spm2 !!!
% --- NOTE 2 ----
% Flip can not be considered in this routine.
%
% 2005/03/03 OY
% 2005/03/28 modified 
% 2005/04/21 second part modified
% 2005/09/09 ver.030b compatible
% 2005/12/22 M.Sato
% 2006/2/3   M.Sato
% 2007/03/05 OY
% * input and output arguments are modified.
% * no save in this routine.
% * comment are modified.
% 2008-12-19 Taku Yoshioka
%   Return 'pXYZmni'
% 2009-01-05 Taku Yoshioka
%   Add parameter 'dxyz' for offset of standard brain mask.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

mask_file = parm.mask_file;
brainfile = parm.brainfile;
snfile    = parm.snfile;

% Max radius to check minimum distance to corresponding point [mm]
if	isfield(parm,'Rlimit')
	Rlimit = parm.Rlimit;
else
	Rlimit = 4; 
end

% Max radius to search corresponding point [mm] in the 1st-step
if	isfield(parm,'Rmax')
	Rmax = parm.Rmax;
else
	Rmax = 2; 
end

% In the 1st-step, nearest point is searched within Rmax
% In the 2nd-step, nearest point is searched for all candidates
% This value determine, efficiency of search,
% but does not change the result

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%% Don't modify %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%
%%% Backward coordinate transformation 
%%%          from the template brain to a subject's brain  
%%% Template file is neurological format (right handed spm).

%
% Load subject brain coordinate
%
[V]=vb_load_cortex(brainfile);  % [m]
Npoint = size(V,1);

% Read image-header
[dim, Trans, XYZmni] = vb_get_image_info(mask_file);
IMGinfo.dim = dim; 
IMGinfo.mat = Trans;
% dim(1:3) - the x, y and z dimensions of the volume
% Trans    - a 4x4 affine transformation matrix mapping from
%            voxel coordinates to MNI-mm-coordinates
% XYZmni    - 3 x n matrix of XYZ locations 
%            mm-coordinates in atlas-template (origin : MNI-space origin)

% Read atlas-template image 
% Z    - 3D image data

avw = avw_img_read(mask_file);
Z   = avw.img;

% Extract mask region
Z = Z(:);
mni_id = find(Z ~= 0); 
Z = Z(mni_id);

% mm-coordinates in atlas-template for brain region
XYZmni = XYZmni(:,mni_id);

fprintf('# of template points = %d\n',length(mni_id))
fprintf('--- Back transformation to subject-image \n');

% Back transformation to subject image
sn = load(deblank(snfile)); 
[pXYZmni] = vb_unsn(XYZmni,sn);  
%[pXYZmni,flip_flag] = vb_unsn_for_mask(XYZmni,sn);  

XYZmni  = XYZmni';	% mm-coordinates in atlas-template (MNI-coordinate)
pXYZmni = pXYZmni';	% mm-coordinates in subject image

%if flip_flag, 
%  XYZmni(:,1) = -1*XYZmni(:,1);
%end

% Offset
if isfield(parm,'dxyz'), 
  pXYZmni = pXYZmni+repmat(parm.dxyz,[size(pXYZmni,1) 1]);
end

% if coordinate system is left-handed spm, flip x-direction coordinate
% pXYZmni(:,1) = -pXYZmni(:,1)  ;

%%%
%%% Map MNI-coordinate to individual's cortical surface
%%%

fprintf('--- Mapping MNI-coordinate onto a cortical surface of a subject-brain \n');

% Find nearest point in atlas for each vertex 'V'
[indx, dd] = vb_find_nearest_point(pXYZmni, V*1000, Rmax, 100, 1, 1);
%figure;
%plot3(V(:,1)*1000,V(:,2)*1000,V(:,3)*1000,'r.');
%hold on;
%plot3(pXYZmni(:,1),pXYZmni(:,2),pXYZmni(:,3),'b.');

% Map template-coordinate to subject cortex
% XYZmni : MNI-coordinate corresponding to V(:,1:3)
XYZmni = XYZmni(indx,:);

% Number of points whose minimum distance is less than Rlimit
ix_match = find( dd <= Rlimit );
Nmatch   = length(ix_match);

% mni2tal : MNI to Talairach coordinate transformation
XYZtal = mni2tal(XYZmni);

% IMGinfo.dim(1:3) - the x, y and z dimensions of the volume
% IMGinfo.mat      - a 4x4 affine transformation matrix mapping from
%                    voxel coordinates to real world coordinates.

% Voxel coordinate in maask_file image
% XYZvox = inv(IMGinfo.mat) * [XYZmni'; ones(1,Npoint)];
% XYZvox = XYZvox(1:3,:)';

% Check inverse-affine transformation
% XYZmni2 = IMGinfo.mat * [XYZvox'; ones(1,Npoint)];
% err  = sum(sum(abs(XYZmni-XYZmni2(1:3,:)')))/sum(sum(abs(XYZmni)))

fprintf('# of cortex  points = %d\n',Npoint)
fprintf('# of points ( d <= %3.0f mm ) = %d\n',Rlimit,Nmatch)
fprintf('# of points ( d >  %3.0f mm ) = %d\n',Rlimit,Npoint - Nmatch)
fprintf('dmax = %4.1f mm \n', max(dd))

xmax = max(XYZtal);
xmin = min(XYZtal);


XYZtal = XYZtal/1000; % mm -> m
XYZmni = XYZmni/1000; % mm -> m
dd     = dd / 1000;   % mm -> m

fprintf('[Xmax, Ymax, Zmax] = %6.1f %6.1f %6.1f\n',xmax)
fprintf('[Xmin, Ymin, Zmin] = %6.1f %6.1f %6.1f\n',xmin)


