function [dipole_parm] = vb_set_dipole_parm_test
% set parameter for dipole search
%  [dipole_parm] = vb_set_dipole_parm_test
%
% 2007-7-12 made by M.Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- Input MEG file(relative path from proj_root)
dipole_parm.megfile   = 'move_artifact.meg.mat';

% --- Output file(relative path from proj_root)
dipole_parm.dipolefile = [];

% set time window & trial number to estimate
dipole_parm.twin_meg = [];	% Time window for analysis
dipole_parm.trial_id = [];	% trial number to estimate

% Error function for dipole search
%  = 0 : 'vb_dipole_error':         for external current (Biot-Savart Eq.)
%  = 1 : 'vb_dipole_error_sarvas':  for cortical current (Sarvas Eq.)
%  = 2 : 'vb_dipole_error_magdipole':  for magnetic dipole
dipole_parm.errfunc = 0;

% initial dipole position [Ndipole x 3]
dipole_parm.Vinit = [0.1 0.0 -1.0];	
%dipole_parm.Vinit = [0.1 0.0 -1.0; 0.0 0.0 -1.0];	
%dipole_parm.Vinit = [0.0 0.0 -0.5; 0.1 0.0 -1.0; 0.0 0.0 -1.0];	
%dipole_parm.Vinit = [0 0 0];	

dipole_parm.MaxIter = 5000;		% max iteration number in optimization
dipole_parm.TolX    = 1.e-8;	% Xνλ
dipole_parm.TolFun  = 1.e-10;	% ؿͤνλ
dipole_parm.Display = 'off';	% = 'iter' or 'off'
dipole_parm.mode    = 1;
	%	 = 0;	% Use 'fminsearch' in Matlab
	%	 = 1;	% Use 'fminunc' in Optimization Toolbox
	%	 = 2;	% Use 'fminunc1'
