function [brain_parm] = vb_set_brain_parm_test(fs_dir)
% Set parameters to create brain model.
%    brain_parm = vb_set_brain_parm([fs_dir]);
%
% [Input]
%         fs_dir : freesurfer subject directory.
% [Output]
%    brain_parm : import parameters to create brain model.
%
% [See also]
%    vb_job_brain.m
%
% 2016-06-02 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Standard parameters
%

%
% Input file(absolute path)
%
if ~exist('fs_dir', 'var')
    fs_dir = '';
end

surf_dir   = fullfile(fs_dir, 'surf');
label_dir  = fullfile(fs_dir, 'label');

% FreeSurfer model(.asc)
% (check : Version 4.2 and 4.5)
brain_parm.FS_left_file         = fullfile(surf_dir,  'lh.smoothwm.asc');
brain_parm.FS_right_file        = fullfile(surf_dir,  'rh.smoothwm.asc');
brain_parm.FS_left_infl_file    = fullfile(surf_dir,  'lh.inflated.asc');
brain_parm.FS_right_infl_file   = fullfile(surf_dir,  'rh.inflated.asc');
brain_parm.FS_left_curv_file    = fullfile(surf_dir,  'lh.curv.asc');
brain_parm.FS_right_curv_file   = fullfile(surf_dir,  'rh.curv.asc');
brain_parm.FS_left_sphere_file  = fullfile(surf_dir,  'lh.sphere.reg.asc');
brain_parm.FS_right_sphere_file = fullfile(surf_dir,  'rh.sphere.reg.asc');
brain_parm.FS_sphere_key        = 'sphere.reg';

brain_parm.FS_left_label_file   = fullfile(label_dir, 'lh.cortex.label');
brain_parm.FS_right_label_file  = fullfile(label_dir, 'rh.cortex.label');

% registration method to standard brain model.
%     = 'FS' : Freesurfer sphere file is used.
brain_parm.registration_mode='FS';

% MRI image
brain_parm.analyze_file = '3D.nii';

%
% Output file(relative path from proj_root)
%
brain_parm.brain_file = 'Subject.brain.mat';
brain_parm.area_file  = 'Subject.area.mat';
brain_parm.act_file   = 'Subject.act.mat';


%
% --- Advanced parameters 
%  Do not change, unless you understand the meaning of the parameters!!
%

% Maximum radius for neighbor search 
brain_parm.R_max = 0.018;

% Total Vertex number(Priority:Nvertex>reduce_ratio)
brain_parm.Nvertex = 10000;

% Reduce ratio for original surface data
brain_parm.reduce_ratio = 0.1;

% Division number of z axis in matching between BV and MRI points
brain_parm.N_step = 50;

% Display progress for this steps
brain_parm.display = 200;
