function brain_parm = vb_set_brain_parm_fsaverage(fsaverage_dir,sbj_dir)
% Set parameters to make cortical surface model 'fsaverage'. 
%
% 'fsaverage' data is used to performe inter-subject analysis of cortical
% current estimated on cortical surface models of individual
% subjects. This function is used with vb_job_brain and
% vb_job_brain_add_sph_coord (see example). The following files are
% required for making cortical surface model: 
%
%  surf/[lh/rh].smoothwm.asc
%  surf/[lh/rh].inflated.asc
%  surf/[lh/rh].curv.asc
%  surf/[lh/rh].sphere.reg.asc
%  mri/T1.[hdr/img/nii] (ANALYZE or NIfTI)
%
% These files are not included in FreeSurfer package. You need to convert
% original files by using FreeSurfer's commands as follows: 
%
%  cd $SUBJECTS_DIR/fsaverage/surf
%  mris_convert [lh/rh].smoothwm [lh/rh].smoothwm.asc
%  mris_convert [lh/rh].inflated [lh/rh].inflated.asc
%  mris_convert -c curv [lh/rh].smoothwm [lh/rh].curv.asc
%  mris_convert [lh/rh].sphere.reg [lh/rh].sphere.reg.asc
%  cd $SUBJECTS_DIR/fsaverage/mri
%  mri_convert --out_type [analyze/nifti1] T1.mgz T1
%
% Where $SUBJECTS_DIR is FreeSurfer's subject directory. 
%
% [syntax]
% brain_parm = vb_set_brain_parm_fsaverage(fsaverage_dir,sbj_dir)
%
% [input]
% fsaverage_dir: <<string>> Directory of subject 'fsaverage'. 
% sbj_dir      : <<string>> VBMEG subject directory for 'fsaverage'. New
%                files (.brain.mat etc.) are put on this directory. This
%                must be a relative path from 'proj_root' directory,
%                which is given to vb_job_brain and
%                vb_job_brain_add_sphcoord.
%
% [output]
% brain_parm: <<struct>> Parameter set for vb_job_brain and
%             vb_job_brain_add_sphcoord.
%
% [example]
% >> fsavr_dir = '/home/cbi-data5/taku-y/analysis/freesurfer/fsaverage';
% >> sbj_dir   = 'brain/fsaverage';
% >> brain_parm = vb_set_brain_parm_fsaverage(fsavr_dir,sbj_dir);
% >> vb_job_brain(proj_root,brain_parm);
% >> vb_job_inflate(proj_root,brain_parm);
% >> vb_job_brain_add_sphcoord(proj_dir,brain_parm);
%
% [history]
% 2010-11-30 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Input files
brain_parm.FS_left_file       = [fsaverage_dir '/surf/lh.smoothwm.asc'];
brain_parm.FS_right_file      = [fsaverage_dir '/surf/rh.smoothwm.asc'];
brain_parm.FS_left_infl_file  = [fsaverage_dir '/surf/lh.inflated.asc'];
brain_parm.FS_right_infl_file = [fsaverage_dir '/surf/rh.inflated.asc'];
brain_parm.FS_left_curv_file  = [fsaverage_dir '/surf/lh.curv.asc'];
brain_parm.FS_right_curv_file = [fsaverage_dir '/surf/rh.curv.asc'];
brain_parm.brain_sphL = [fsaverage_dir '/surf/lh.sphere.reg.asc'];
brain_parm.brain_sphR = [fsaverage_dir '/surf/rh.sphere.reg.asc'];

brain_parm.analyze_file = [fsaverage_dir '/mri/T1.hdr'];
brain_parm.spm_normalization_file = [];

% Output files (relative path from proj_root)
brain_parm.brain_file  = [sbj_dir filesep 'fsaverage.brain.mat'];
brain_parm.area_file   = [sbj_dir filesep 'fsaverage.area.mat'];
brain_parm.act_file    = [sbj_dir filesep 'fsaverage.act.mat'];

% ID of sphere coordinate
brain_parm.key         = 'sphere.reg';

%
% --- Advanced parameters 
%  Do not change, unless you understand the meaning of the parameters!!
%

% Maximum radius for neighbor search 
brain_parm.R_max = 18e-3; % 18mm

% Total Vertex number after reduction(Priority:Nvertex>reduce_ratio)
brain_parm.Nvertex = 20000;

% Reduce ratio for BV surface data
brain_parm.reduce_ratio = 0.1;

% Division number of z axis in matching between BV and MRI points
brain_parm.N_step = 50;

% Display progress for this steps
brain_parm.display = 200;

return;
