function fh = vb_plot_slice_surf(B,V,F,indx,vdim,Nsubfig,Mtype,dmax,xymode,Msize)
% Plot surface on MRI slice image
% -- Syntax
% vb_plot_slice_surf( B, V, F, indx, vdim)
% h = vb_plot_slice_surf( B, V, F, indx, vdim, Nfig, Mtype, dmax, xymode, Msize)
%
% -- Input
% B : 3D-image
%     if B = [], only surface section is plotted
% V : vertex coordinate in analyze_right voxcel coordinate
% F : patch index
% --- Optinal Input            ( = Default)
% indx  : slice index to plot  ( = [140:10:190])
% vdim  : axis to cut slice    ( = 'z')
%       : 'x' or 'y' or 'z' 
% Nfig  : # of subplot         ( = [3, 3])
% Mtype : Line style           ( = 'y-')
% Msize : Line width           ( = 1)
% dmax  : search distance from cut slice ( = 5)
% xymode :  2D plot mode for X-Y         ( = 0)
%        = 0   : plot without transpose
%        = 1   : plot by transposing 2D-image matrix
% -- Output
% h : figure handle
% --- Related function
%  vb_plot_slice( B, V, zindx, vertex_mode, Nsubfig, Msize)
%
% 2006/10/20 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('vdim'),    vdim = 'z'; end
if ~exist('indx'),    indx = [140:10:190]; end
if ~exist('Nsubfig'), Nsubfig = [3, 3] ; end
if ~exist('Mtype'),   Mtype = 'y-'; end
if ~exist('Msize'),   Msize = 1; end
if ~exist('dmax'),    dmax = 5; end
if ~exist('xymode','var'), xymode = 0; end; 

NX=Nsubfig(1); 
NY=Nsubfig(2); 

Nfig = length(indx);

if ~isempty(B)
	nfig = NX*NY;
else
	nfig = 0;
end

fh = [];

for n=1:Nfig
	if nfig==NX*NY, 
		h = figure; nfig=1; fh = [fh, h];
	else
		nfig=nfig+1;
	end;
	
	subplot(NY,NX,nfig);
	
	% MRI slice plot
	if ~isempty(B)
		vb_plot_3d_image(B, indx(n), vdim, xymode);
		axis('equal'); 
		axis('tight');
		title([vdim '-slice (' num2str(indx(n),3) ')'])
		colormap(gray);
		hold on
	end
%	xlabel('X');
%	ylabel('Y');
	
	% Plot intersection of surface
    if ~isempty(V)
    	vb_plot_cross_section(V,F,indx(n),vdim,dmax,Msize,Mtype,xymode);
    end
end;

colormap(gray);
%colormap(jet);


