function	vb_plot_slice_multi(B,V,zindx,mode,Nsubfig,Msize,Mtype,dz,vdim)
% plot transverse slice image 
%
% B : 3D-image
% V : vertex coordinate
%     if empty, no vertex plot
% zindx : slice z-coordinate
% mode : 2D plot mode for X-Y 
%      = 0   : plot without transpose
%      = 1   : plot by transposing 2D-image matrix
% Nsubfig = [NX NY] : # of Subplot 
% Msize : Marker size
% Mtype : Marker type
% dz   : slice width
% vdim : slice cut direction
%      = 'x' : Sagittal cut : Y-Z plane
%      = 'y' : Coronal cut : X-Z plane
%      = 'z' : Transverse (Axial) cut : X-Y plane
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% written by M. Sato  2005-8-1

% zindx : slice z-coordinate
if nargin < 3, zindx = [2:2:60]; end;

% Mode switch for Vertex plot
if nargin < 4, mode=0; end;

% # of Subplot 
if nargin < 5, Nsubfig = [ 3, 3 ]; end;

% Marker size
if nargin < 6, Msize=2; end;

% Marker type
if nargin < 7, Mtype='y.'; end;

% Slice width
if nargin < 8, dz=1.5; end;

% Slice direction
if nargin < 9, vdim='z'; end;

NX=Nsubfig(1); 
NY=Nsubfig(2); 

% z-width for vartex selection
dz = 1;

Nfig = length(zindx);
nfig = NX*NY;

for n=1:Nfig
	if nfig==NX*NY, 
		figure; nfig=1;
	else
		nfig=nfig+1;
	end;
	
	subplot(NY,NX,nfig);
	z = zindx(n);
	
	[strX,strY,strZ] = vb_plot_3d_image(B, z, vdim, mode);
	
	title(sprintf('%s-slice (%3d)',strZ,zindx(n)))
	xlabel(strX);
	ylabel(strY);

	hold on
	
	if ~exist('V','var') | isempty(V), continue; end;
	
	% vertex plot
	vb_plot_vertex(V, vdim, z, dz, Msize, Mtype, mode)
end;

%colormap(gray);
%colormap(jet);


