function vb_plot_head_surf(headfile,brainfile,plot_parm)
% Plot head shape and cortex surface
%  vb_plot_head_surf(headfile,brainfile)
%  vb_plot_head_surf(headfile,brainfile,plot_parm)
% --- Input
% headfile{n}
% brainfile
% --- Optional Input
% plot_parm.mode = 0: overplot head on cortex
%                = 1: plot head and cortex separately
%
% 2006/10/19 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~iscell(headfile), headfile = {headfile}; end;

if ~exist('plot_parm','var'), plot_parm = []; end;

if ~isfield(plot_parm,'mode'),   plot_parm.mode = 0; end;
if ~isfield(plot_parm,'vangle'), plot_parm.vangle = [40 25 ]; end

% # of head file
N = length(headfile);

% # of plot
if exist('brainfile','var') & ~isempty(brainfile)
	Nfig = N + 1;
else
	Nfig = N;
end

light_mode = 0;
max_mode   = 1;

figure
nfig = 0;

if plot_parm.mode==1,
	if isfield(plot_parm,'NX'), 
		NX = plot_parm.NX;
	else
		NX = 2; 
	end
	NY   = ceil(Nfig/NX);
	nfig = nfig + 1;
	subplot(NY,NX,nfig)
end

% 
% --- Plot cortex
%
if exist('brainfile','var') & ~isempty(brainfile)
	load(brainfile,'V','F')
	F = F.F3;

	%vb_plot_surf(V,F,[],[],light_mode,max_mode)
	vb_plot_surf(V,F,'none','k')
	hold on
	view(plot_parm.vangle)
end

% 
% --- Plot Head
%

for n=1:N
	load(headfile{n},'Vhead','Fhead')
	
	if plot_parm.mode==1,
		nfig = nfig + 1;
		subplot(NY,NX,nfig)
	end
	
	vb_plot_surf(Vhead,Fhead,[],[],light_mode,max_mode)
	hold on
	view(plot_parm.vangle)
end

%alpha(0.5);

clear Vhead Fhead V F

