function vb_plot_brain_flat(plot_parm)
% ---
% function vb_plot_brain_flat(plot_parm)
%
% This function supports high resolution patch created by
% FreeSurfer. Note that the vertex resolution can be different
% between the flat map (high resolution) and estimation model (low
% resolution). Thus, ix_J must be the indices on the flat map. 
% The translation table from the high-resolution model to the
% low-resolution model is included in cortical model file
% (.brain.mat) as variable 'BV_index'. See sample script
% 'job_plot_brain_flat_sample.m'. 
%
% --- Necessary parameters
% plot_parm.V      : Vertices of the flat map
% plot_parm.F      : Faces of the flat map
% plot_parm.C      : Curvature (discritized for visualization)
%
% --- Optional parameters
% plot_parm.J       : Activity map
% plot_parm.ix_J    : Vertex index of flatmap for J
% plot_parm.cmap    : Color map (1:jet 2:hot, default 1)
% plot_parm.wmode   : 1:absolute, 2:real value (default 1)
% plot_parm.wmax    : Relative cutoff value (0-1, default 1)
% plot_parm.wmin    : Relative minimum threshold (0-1, default 0.1)
% plot_parm.paint   : 1:off 2:on (default 1)
% plot_parm.th_curv : Relative threshold of curvature (default 0.5)
% plot_parm.color   : Color of flatmap (default [0.7 0.7 0.7])
% plot_parm.ms      : Marker size (default 5.0)
% plot_parm.ix_area : Vertex indices of area (cell array)
% plot_parm.clr_area: Color of areas to be displayed (cell array)
%
% 2006-03-24 Taku Yoshioka
% ---
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Setup optional parameters
if ~isfield(plot_parm,'J'), plot_parm.J = []; end; 
if ~isfield(plot_parm,'cmap'), plot_parm.cmap = 'jet'; end;
if ~isfield(plot_parm,'wmode'), plot_parm.wmode = 1; end; 
if ~isfield(plot_parm,'wmax'), plot_parm.wmax = 1.0; end; 
if ~isfield(plot_parm,'wmin'), plot_parm.wmin = 0.1; end; 
if ~isfield(plot_parm,'paint'), plot_parm.paint = 2; end; 
if ~isfield(plot_parm,'th_curv'), plot_parm.th_curv = 0.5; end; 
if ~isfield(plot_parm,'color'), plot_parm.color = [0.7 0.7 0.7]; end; 
if ~isfield(plot_parm,'ms'), plot_parm.ms = 5.0; end;
if ~isfield(plot_parm,'ix_area'), plot_parm.ix_area = []; end; 

% Patch color
ix = find(plot_parm.C>plot_parm.th_curv); 
C = ones(length(plot_parm.C),1);
C(ix) = 0.4; 
fclr = [C C C].*repmat(plot_parm.color,[size(C,1) 1]);

% Plot flat map
patch('Faces',plot_parm.F,'Vertices',plot_parm.V,...
      'FaceVertexCData',fclr,'FaceColor','interp',...
      'EdgeColor','none');

% Plot activity map
if ~isempty(plot_parm.J), 
  hold on; 
  colormap(plot_parm.cmap);
  ix = find(plot_parm.J>abs(max(plot_parm.J))*plot_parm.wmin);
  plot_parm.ix_J = plot_parm.ix_J(ix);
  plot_parm.J = plot_parm.J(ix);
  
  if isfield(plot_parm,'mtype'), 
    h = scatter3(plot_parm.V(plot_parm.ix_J,1),...
		 plot_parm.V(plot_parm.ix_J,2),...
		 plot_parm.V(plot_parm.ix_J,3),...
		 plot_parm.ms,plot_parm.J,'filled');
    set(h,'MarkerSize',plot_parm.ms);
  else
    h = scatter3(plot_parm.V(plot_parm.ix_J,1),...
		 plot_parm.V(plot_parm.ix_J,2),...
		 plot_parm.V(plot_parm.ix_J,3),...
		 plot_parm.ms,plot_parm.J,'filled');
  end
end

% Plot areas 
if ~isempty(plot_parm.ix_area),
  hold on; 
  for i=1:length(plot_parm.ix_area)
    h = plot3(plot_parm.V(plot_parm.ix_area{i},1),...
	      plot_parm.V(plot_parm.ix_area{i},2),...
	      plot_parm.V(plot_parm.ix_area{i},3),...
	      '.','MarkerSize',plot_parm.ms);
    set(h,'MarkerFaceColor',plot_parm.clr_area{i});
    set(h,'MarkerEdgeColor',plot_parm.clr_area{i});
    if isfield(plot_parm,'mtype'), 
      set(h,'Marker',plot_parm.mtype); 
    end
  end
end
