function vb_plot_act_to_analyze(analyzefile,brainfile,actfile,act_key)
% plot act data( Act in *.act.mat ) to analyze file
%
% vb_plot_act_to_analyze(analyzefile,brainfile,actfile,act_number)
%
% --- Input
% analyzefile : String   analyze image (T1) file name (*.hdr)
% brainfile : String   brain file name (*.brain.mat)
% actfile : String   act file file name (*.act.mat)
% act_number : N    act number (Act{N})
% --- Output
% figure : plot act infomation point on the analyze image 
%
% written by M Osako  2006-06-14
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%% transform analyze coord (left-handed) to right-handed coord
[B, Vdim, Vsize] = vb_load_analyze_to_right(analyzefile);

[V,F] = vb_load_cortex(brainfile);
Act = vb_get_act(actfile,act_key);

%% transform spm right-handed coord to analyze coord
Vana = vb_spm_right_to_analyze_right(V,Vdim,Vsize);

%% search act point 
V_act=Vana(find(Act.xxP > 0.2*10^(-10)),:);

%% set Z coord scale
V_act_min=fix(min(V_act(:,3)));
V_act_max=ceil(max(V_act(:,3)));
Vact_scale=V_act_min:V_act_max;

ZScale_Vact = sort(fix(V_act(:,3)));
Vz=[];
for n=1:length(Vact_scale),
    if sum(find(Vact_scale(n) == ZScale_Vact)) > 0,
        Vz=[Vz ; Vact_scale(n)];
    end
end

%%plot act point on the analyze image
vb_plot_slice( B,V_act,Vz );
